package ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.add;

import java.util.List;

import ru.yandex.direct.core.entity.adgroup.container.ComplexAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.retargeting.model.RetargetingConditionBase;
import ru.yandex.direct.core.entity.retargeting.service.RetargetingConditionOperationFactory;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.operation.tree.ListSubOperationExecutor;
import ru.yandex.direct.operation.tree.SubOperationCreator;
import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

public class RetargetingConditionLogicSupplier<T extends ComplexAdGroup> extends AddSubEntityLogicSupplier<T> {
    private ListSubOperationExecutor<AdGroup, RetargetingConditionBase, AddRetargetingConditionsSubOperation> retargetingConditionsExecutor;

    public RetargetingConditionLogicSupplier(List<T> complexAdGroups,
                                             ModelProperty<? super T, List<RetargetingConditionBase>> retargetingConditionProperty,
                                             RetargetingConditionOperationFactory retargetingConditionOperationFactory, ClientId clientId) {
        super(complexAdGroups);
        createRetargetingsExecutor(retargetingConditionProperty, retargetingConditionOperationFactory, clientId);
    }

    private void createRetargetingsExecutor(ModelProperty<? super T, List<RetargetingConditionBase>> retargetingConditionProperty,
                                            RetargetingConditionOperationFactory retargetingConditionOperationFactory, ClientId clientId) {
        SubOperationCreator<RetargetingConditionBase, AddRetargetingConditionsSubOperation> subOperationCreator =
                retargetingConditions -> new AddRetargetingConditionsSubOperation(retargetingConditionOperationFactory,
                        retargetingConditions, clientId);

        retargetingConditionsExecutor = ListSubOperationExecutor.builder()
                .withFakeParents(complexAdGroups)
                .withChildrenProperty(retargetingConditionProperty)
                .createSubOperationBy(subOperationCreator);
    }

    public ListSubOperationExecutor<AdGroup, RetargetingConditionBase, AddRetargetingConditionsSubOperation> getRetargetingConditionsExecutor() {
        return retargetingConditionsExecutor;
    }

    @Override
    public void prepare(ValidationResult<List<AdGroup>, Defect> adGroupsResult) {
        retargetingConditionsExecutor.prepare(adGroupsResult);
    }

    @Override
    public void apply(MassResult<Long> addAdGroupsResult) {
        retargetingConditionsExecutor.apply();
    }
}
