package ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.common;

import java.util.List;

import ru.yandex.direct.core.entity.vcard.model.Vcard;
import ru.yandex.direct.core.entity.vcard.service.AddVcardOperation;
import ru.yandex.direct.core.entity.vcard.service.VcardService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.operation.tree.SubOperation;
import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.result.Result;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static com.google.common.base.Preconditions.checkArgument;
import static java.util.Collections.emptyList;
import static ru.yandex.direct.operation.tree.TreeOperationUtils.prepareNullableOperationAndGetValidationResult;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

public class AddVcardsSubOperation implements SubOperation<Vcard> {

    private final List<Vcard> vcards;
    private final AddVcardOperation addVcardOperation;

    private List<Long> vcardIds;

    public AddVcardsSubOperation(VcardService vcardService, List<Vcard> vcards,
                                 long operatorUid, ClientId clientId) {
        checkArgument(vcards != null, "sub operation must not be created with null vcards list");
        this.vcards = vcards;
        this.addVcardOperation = vcards.isEmpty() ?
                null :
                vcardService.createFullAddVcardOperationAsPartOfComplexOperation(vcards, operatorUid, clientId);
    }

    public ValidationResult<List<Vcard>, Defect> prepare() {
        return prepareNullableOperationAndGetValidationResult(addVcardOperation, vcards);
    }

    public void apply() {
        if (addVcardOperation != null) {
            MassResult<Long> result = addVcardOperation.apply();
            vcardIds = mapList(result.getResult(), Result::getResult);
            setMissedVcardIds();
        } else {
            vcardIds = emptyList();
        }
    }

    public List<Vcard> getVcards() {
        return vcards;
    }

    /**
     * Проставляет недостающие id (они могут быть не проставлены если визитка - дубликат)
     */
    private void setMissedVcardIds() {
        for (int vcardIndex = 0; vcardIndex < vcardIds.size(); vcardIndex++) {
            Vcard vcard = vcards.get(vcardIndex);
            if (vcard.getId() == null) {
                vcard.setId(vcardIds.get(vcardIndex));
            }
        }
    }
}
