package ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.update;

import java.util.List;

import ru.yandex.direct.core.entity.adgroup.container.ComplexAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.retargeting.model.RetargetingConditionBase;
import ru.yandex.direct.core.entity.retargeting.model.TargetInterest;
import ru.yandex.direct.core.entity.retargeting.service.RetargetingConditionOperationFactory;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.operation.tree.ItemSubOperationExecutor;
import ru.yandex.direct.operation.tree.SubOperationCreator;
import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.utils.FunctionalUtils.filterList;

public class AddUpdateRetargetingConditionLogicSupplier<T extends ComplexAdGroup> extends UpdateSubEntityLogicSupplier<T>  {
    private ItemSubOperationExecutor<AdGroup, RetargetingConditionBase, AddUpdateRetargetingConditionSubOperation>
            retargetingConditionExecutor;

    public AddUpdateRetargetingConditionLogicSupplier(List<T> complexAdGroups,
                                                      ModelProperty<? super T, RetargetingConditionBase> retargetingConditionProperty,
                                                      RetargetingConditionOperationFactory retargetingConditionOperationFactory,
                                                      ClientId clientId) {
        super(complexAdGroups);
        createRetargetingConditionExecutor(retargetingConditionProperty,
                retargetingConditionOperationFactory, clientId);
    }

    private void createRetargetingConditionExecutor(
            ModelProperty<? super T, RetargetingConditionBase> retargetingConditionProperty,
            RetargetingConditionOperationFactory retargetingConditionOperationFactory, ClientId clientId) {
        SubOperationCreator<RetargetingConditionBase, AddUpdateRetargetingConditionSubOperation> subOperationCreator =
                retargetingConditions -> new AddUpdateRetargetingConditionSubOperation(
                        retargetingConditions,
                        retargetingConditionOperationFactory,
                        clientId
                );
        retargetingConditionExecutor = ItemSubOperationExecutor.builder()
                .withFakeParents(complexAdGroups)
                .withChildProperty(retargetingConditionProperty)
                .createSubOperationBy(subOperationCreator);
    }

    private void setFakeRetargetingConditionIds() {
        List<RetargetingConditionBase> retargetingConditions =
                retargetingConditionExecutor.getSubOperation()
                        .getRetargetingConditions();

        if (retargetingConditions != null && !retargetingConditions.isEmpty()) {
            filterList(retargetingConditions, rc -> rc.getId() == null)
                    .forEach(rc -> {
                        TargetInterest targetInterest = rc.getTargetInterest();
                        long fakeRetCondId = -targetInterest.getAdGroupId();
                        rc.withId(fakeRetCondId);
                        targetInterest.withRetargetingConditionId(fakeRetCondId);
                    });
        }
    }

    @Override
    public void prepare(ValidationResult<List<AdGroup>, Defect> adGroupsResults) {
        retargetingConditionExecutor.prepare(adGroupsResults);
        setFakeRetargetingConditionIds();
    }

    private void setRealRetargetingConditionIds() {
        List<RetargetingConditionBase> retargetingConditions =
                retargetingConditionExecutor.getSubOperation().getRetargetingConditions();

        if (retargetingConditions != null && !retargetingConditions.isEmpty()) {
            filterList(retargetingConditions, rc -> rc.getTargetInterest() != null)
                    .forEach(rc -> rc.getTargetInterest().withRetargetingConditionId(rc.getId()));
        }
    }

    @Override
    public void apply(MassResult<Long> updateAdGroupsResult) {
        retargetingConditionExecutor.apply();
        setRealRetargetingConditionIds();
    }

}
