package ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.update;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import ru.yandex.direct.core.entity.retargeting.model.RetargetingCondition;
import ru.yandex.direct.core.entity.retargeting.model.RetargetingConditionBase;
import ru.yandex.direct.core.entity.retargeting.service.AddRetargetingConditionsOperation;
import ru.yandex.direct.core.entity.retargeting.service.RetargetingConditionOperationFactory;
import ru.yandex.direct.core.entity.retargeting.service.RetargetingConditionsUpdateOperation;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.operation.Applicability;
import ru.yandex.direct.operation.tree.SubOperation;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static com.google.common.base.Preconditions.checkArgument;
import static ru.yandex.direct.operation.tree.ItemSubOperationExecutor.extractSubList;
import static ru.yandex.direct.operation.tree.TreeOperationUtils.mergeSubListValidationResults;
import static ru.yandex.direct.operation.tree.TreeOperationUtils.prepareNullableOperationAndGetValidationResult;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

public class AddUpdateRetargetingConditionSubOperation implements SubOperation<RetargetingConditionBase> {

    private List<RetargetingConditionBase> allRetargetingConditions;

    private List<RetargetingConditionBase> retargetingConditionsToAdd;
    private Map<Integer, Integer> addRetargetingConditionsIndexMap;
    private AddRetargetingConditionsOperation retargetingConditionsAddOperation;

    private List<RetargetingConditionBase> retargetingConditionsToUpdate;
    private Map<Integer, Integer> updateRetargetingConditionsIndexMap;
    private RetargetingConditionsUpdateOperation retargetingConditionsUpdateOperation;

    public AddUpdateRetargetingConditionSubOperation(List<RetargetingConditionBase> retargetingConditions,
                                                     RetargetingConditionOperationFactory retargetingConditionOperationFactory,
                                                     ClientId clientId) {
        checkArgument(retargetingConditions != null, "sub operation must not be created with empty retargeting сondition list");

        this.allRetargetingConditions = retargetingConditions;

        createAddOperation(retargetingConditionOperationFactory, retargetingConditions, clientId);
        createUpdateOperation(retargetingConditionOperationFactory, retargetingConditions, clientId);
    }

    private void createAddOperation(RetargetingConditionOperationFactory retargetingConditionOperationFactory,
                                    List<RetargetingConditionBase> retargetingConditions,
                                    ClientId clientId) {
        addRetargetingConditionsIndexMap = new HashMap<>();
        retargetingConditionsToAdd = extractSubList(addRetargetingConditionsIndexMap, retargetingConditions, retargetingCondition -> retargetingCondition.getId() == null);
        if (!retargetingConditionsToAdd.isEmpty()) {
            this.retargetingConditionsAddOperation = retargetingConditionOperationFactory
                    .createAddOperation(Applicability.FULL, mapList(retargetingConditionsToAdd, rc -> (RetargetingCondition) rc.withClientId(clientId.asLong())), clientId);
        }
    }

    private void createUpdateOperation(RetargetingConditionOperationFactory retargetingConditionOperationFactory,
                                       List<RetargetingConditionBase> retargetingConditions, ClientId clientId) {
        updateRetargetingConditionsIndexMap = new HashMap<>();
        retargetingConditionsToUpdate = extractSubList(updateRetargetingConditionsIndexMap, retargetingConditions, retargetingCondition -> retargetingCondition.getId() != null);
        if (!retargetingConditionsToUpdate.isEmpty()) {
            List<ModelChanges<RetargetingCondition>> changesList = mapList(retargetingConditionsToUpdate,
                    UpdateRetargetingConditionsSubOperation::retargetingConditionToModelChanges);
            this.retargetingConditionsUpdateOperation = retargetingConditionOperationFactory
                    .createUpdateOperation(Applicability.FULL, changesList, clientId, true, true);
        }
    }

    public ValidationResult<List<RetargetingConditionBase>, Defect> prepare() {
        ValidationResult<List<RetargetingConditionBase>, Defect> validationResult = new ValidationResult<>(allRetargetingConditions);

        ValidationResult<List<RetargetingConditionBase>, Defect> addValidationResult =
                prepareNullableOperationAndGetValidationResult(retargetingConditionsAddOperation, retargetingConditionsToAdd);
        ValidationResult<List<RetargetingConditionBase>, Defect> updateValidationResult =
                prepareNullableOperationAndGetValidationResult(retargetingConditionsUpdateOperation, retargetingConditionsToUpdate);

        mergeSubListValidationResults(validationResult, addValidationResult, addRetargetingConditionsIndexMap);
        mergeSubListValidationResults(validationResult, updateValidationResult, updateRetargetingConditionsIndexMap);

        afterRetargetingConditionsPrepare(validationResult);

        return validationResult;
    }

    protected void afterRetargetingConditionsPrepare(ValidationResult<List<RetargetingConditionBase>, Defect> validationResult) {
    }

    public void apply() {
        beforeRetargetingConditionsApply();

        if (retargetingConditionsAddOperation != null) {
            retargetingConditionsAddOperation.apply();
        }

        if (retargetingConditionsUpdateOperation != null) {
            retargetingConditionsUpdateOperation.apply();
        }
    }

    protected void beforeRetargetingConditionsApply() {
    }

    public List<RetargetingConditionBase> getRetargetingConditions() {
        return allRetargetingConditions;
    }
}
