package ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.update;

import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;

import one.util.streamex.EntryStream;

import ru.yandex.direct.core.entity.adgroup.container.ComplexAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields;
import ru.yandex.direct.core.entity.banner.service.BannersAddOperationFactory;
import ru.yandex.direct.core.entity.banner.service.BannersUpdateOperationFactory;
import ru.yandex.direct.core.entity.banner.service.DatabaseMode;
import ru.yandex.direct.core.entity.banner.service.moderation.ModerationMode;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.operation.tree.ListSubOperationExecutor;
import ru.yandex.direct.operation.tree.SubOperationCreator;
import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.result.Result;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static org.apache.commons.collections4.CollectionUtils.isEmpty;

public class BannerLogicSupplier<T extends ComplexAdGroup, B extends BannerWithSystemFields> extends UpdateSubEntityLogicSupplier<T> {

    protected final ListSubOperationExecutor<AdGroup, B, ? extends UpdateBannersSubOperation<B>> bannerExecutor;

    public BannerLogicSupplier(List<T> complexAdGroups,
                               ModelProperty<? super T, List<B>> bannersProperty,
                               BannersAddOperationFactory bannersAddOperationFactory,
                               BannersUpdateOperationFactory bannersUpdateOperationFactory,
                               long operatorUid, ClientId clientId, ModerationMode moderationMode) {
        this(complexAdGroups,
                BannerLogicSupplier.<T, B>defaultModelsInterconnectionsFiller(bannersProperty),
                BannerLogicSupplier.<T, B>defaultBannerExecutorProvider(bannersProperty,
                        bannersAddOperationFactory, bannersUpdateOperationFactory,
                        operatorUid, clientId, moderationMode)
        );
    }

    protected BannerLogicSupplier(
            List<T> complexAdGroups,
            Consumer<List<T>> modelsInterconnectionsFiller,
            Function<List<T>, ListSubOperationExecutor<AdGroup, B,
                    ? extends UpdateBannersSubOperation<B>>> bannerExecutorProvider
    ) {
        super(complexAdGroups);
        modelsInterconnectionsFiller.accept(complexAdGroups);
        this.bannerExecutor = bannerExecutorProvider.apply(complexAdGroups);
    }

    public ListSubOperationExecutor<AdGroup, B, ? extends UpdateBannersSubOperation<B>> getBannerExecutor() {
        return bannerExecutor;
    }

    @Override
    public void prepare(ValidationResult<List<AdGroup>, Defect> adGroupsResult) {
        bannerExecutor.prepare(adGroupsResult);
    }

    @Override
    public void apply(MassResult<Long> updateAdGroupsResult) {
        bannerExecutor.getSubOperation().setElementIndexesToApply(
                EntryStream.of(bannerExecutor.getIndexMultimap().asMap())
                        .mapKeys(updateAdGroupsResult::get)
                        .filterKeys(Result::isSuccessful)
                        .flatMapValues(Collection::stream)
                        .values()
                        .toSet());
        bannerExecutor.apply();
    }

    private static <T extends ComplexAdGroup, B extends BannerWithSystemFields> Consumer<List<T>> defaultModelsInterconnectionsFiller(
            ModelProperty<? super T, List<B>> bannersProperty) {
        return complexAdGroups -> {
            for (T complexAdGroup : complexAdGroups) {
                List<B> banners = bannersProperty.get(complexAdGroup);
                if (!isEmpty(banners)) {
                    Long adGroupId = complexAdGroup.getAdGroup().getId();
                    banners.forEach(banner -> banner.setAdGroupId(adGroupId));
                }
            }
        };
    }

    private static <T extends ComplexAdGroup, B extends BannerWithSystemFields> Function<List<T>, ListSubOperationExecutor<AdGroup,
            B, ? extends UpdateBannersSubOperation<B>>>
    defaultBannerExecutorProvider(
            ModelProperty<? super T, List<B>> bannersProperty,
            BannersAddOperationFactory bannersAddOperationFactory,
            BannersUpdateOperationFactory bannersUpdateOperationFactory,
            long operatorUid, ClientId clientId, ModerationMode moderationMode) {
        return complexAdGroups -> {
            SubOperationCreator<B, UpdateBannersSubOperation<B>> subOperationCreator =
                    banners -> new UpdateBannersSubOperation<>(moderationMode, banners, bannersAddOperationFactory,
                            bannersUpdateOperationFactory, operatorUid, clientId, false, DatabaseMode.ONLY_MYSQL);

            return ListSubOperationExecutor.builder()
                    .withFakeParents(complexAdGroups)
                    .withChildrenProperty(bannersProperty)
                    .createSubOperationBy(subOperationCreator);
        };
    }
}
