package ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.update;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import one.util.streamex.EntryStream;

import ru.yandex.direct.core.entity.adgroup.container.ComplexAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.common.SetBidModifiersSubOperation;
import ru.yandex.direct.core.entity.bidmodifier.ComplexBidModifier;
import ru.yandex.direct.core.entity.bidmodifiers.service.BidModifierService;
import ru.yandex.direct.core.entity.bidmodifiers.service.ComplexBidModifierService;
import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithType;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.operation.tree.ItemSubOperationExecutor;
import ru.yandex.direct.operation.tree.SubOperationCreator;
import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static com.google.common.base.Preconditions.checkState;

public class BidModifierLogicSupplier<T extends ComplexAdGroup> extends UpdateSubEntityLogicSupplier<T> {
    private ItemSubOperationExecutor<AdGroup, ComplexBidModifier, SetBidModifiersSubOperation> bidModifierExecutor;

    private final Set<Long> affectedAdGroupIds;
    private final CampaignRepository campaignRepository;
    private final ClientId clientId;
    private final int shard;
    private final ModelProperty<? super T, ComplexBidModifier> complexBidModifierProperty;
    private final BidModifierService bidModifierService;
    private final ComplexBidModifierService complexBidModifierService;
    private final long operatorUid;

    public BidModifierLogicSupplier(List<T> complexAdGroups,
                                    ModelProperty<? super T, ComplexBidModifier> complexBidModifierProperty,
                                    Set<Long> affectedAdGroupIds, BidModifierService bidModifierService,
                                    ComplexBidModifierService complexBidModifierService,
                                    CampaignRepository campaignRepository,
                                    long operatorUid, ClientId clientId, int shard) {
        super(complexAdGroups);

        this.affectedAdGroupIds = affectedAdGroupIds;
        this.campaignRepository = campaignRepository;
        this.clientId = clientId;
        this.shard = shard;

        this.operatorUid = operatorUid;
        this.complexBidModifierService = complexBidModifierService;
        this.bidModifierService = bidModifierService;
        this.complexBidModifierProperty = complexBidModifierProperty;
    }

    private void createBidModifierExecutor(ModelProperty<? super T, ComplexBidModifier> complexBidModifierProperty,
                                           BidModifierService bidModifierService,
                                           ComplexBidModifierService complexBidModifierService,
                                           long operatorUid, ClientId clientId, int shard) {
        SubOperationCreator<ComplexBidModifier, SetBidModifiersSubOperation> subOperationCreator =
                complexBidModifiers -> new SetBidModifiersSubOperation(clientId, operatorUid, shard,
                        bidModifierService, complexBidModifierService, complexBidModifiers);
        bidModifierExecutor = ItemSubOperationExecutor.builder()
                .withFakeParents(complexAdGroups)
                .withChildProperty(complexBidModifierProperty)
                .createSubOperationBy(subOperationCreator);
    }

    @Override
    public void prepare(ValidationResult<List<AdGroup>, Defect> adGroupsResults) {

        if (bidModifierExecutor == null) {
            createBidModifierExecutor(complexBidModifierProperty, bidModifierService, complexBidModifierService,
                    operatorUid, clientId, shard);
        }

        Map<Long, CampaignWithType> adGroupIdToCampaignTypeMap =
                campaignRepository.getCampaignsWithTypeByAdGroupIds(shard, clientId, affectedAdGroupIds);
        checkState(adGroupIdToCampaignTypeMap.size() == affectedAdGroupIds.size(),
                "can't fetch campaigns for all successfully validated adGroups, "
                        + "it may point to parallel modifications");

        Map<Long, Long> adGroupIdToCampaignIdMap = EntryStream.of(adGroupIdToCampaignTypeMap)
                .mapValues(CampaignWithType::getId)
                .toMap();

        Map<Integer, Long> bidModifierIndexToAdGroupIdMap = new HashMap<>();
        Map<Integer, CampaignType> bidModifierIndexToCampaignTypeMap = new HashMap<>();
        Map<Integer, AdGroup> bidModifierIndexToAdGroupWithTypeMap = new HashMap<>();

        bidModifierExecutor.getIndexMap().forEach((adGroupIndex, complexBidModifierIndex) -> {
            Long adGroupId = adGroups.get(adGroupIndex).getId();
            CampaignWithType campaignWithType = adGroupIdToCampaignTypeMap.get(adGroupId);
            bidModifierIndexToAdGroupIdMap.put(complexBidModifierIndex, adGroupId);
            bidModifierIndexToCampaignTypeMap.put(complexBidModifierIndex, campaignWithType.getType());
            bidModifierIndexToAdGroupWithTypeMap.put(complexBidModifierIndex, adGroups.get(adGroupIndex));
        });

        bidModifierExecutor.getSubOperation().setCampaignTypesBeforePrepare(bidModifierIndexToCampaignTypeMap);
        bidModifierExecutor.getSubOperation().setAdGroupWithTypesBeforePrepare(bidModifierIndexToAdGroupWithTypeMap);

        bidModifierExecutor.prepare(adGroupsResults);

        bidModifierExecutor.getSubOperation().setAdGroupsInfoBeforeApply(bidModifierIndexToAdGroupIdMap,
                adGroupIdToCampaignIdMap, affectedAdGroupIds);
    }

    @Override
    public void apply(MassResult<Long> updateAdGroupsResult) {
        bidModifierExecutor.apply();
    }
}
