package ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.update;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

import ru.yandex.direct.core.entity.adgroup.container.ComplexAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.adgroup.model.AdGroupSimple;
import ru.yandex.direct.core.entity.banner.container.ComplexBanner;
import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields;
import ru.yandex.direct.core.entity.banner.model.TextBanner;
import ru.yandex.direct.core.entity.banner.service.BannersAddOperationFactory;
import ru.yandex.direct.core.entity.banner.service.BannersUpdateOperationFactory;
import ru.yandex.direct.core.entity.banner.service.moderation.ModerationMode;
import ru.yandex.direct.core.entity.sitelink.service.SitelinkSetService;
import ru.yandex.direct.core.entity.vcard.service.VcardService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.operation.tree.ListSubOperationExecutor;
import ru.yandex.direct.operation.tree.SubOperationCreator;

import static org.apache.commons.collections4.CollectionUtils.isEmpty;
import static ru.yandex.direct.core.entity.adgroup.service.complex.ComplexAdGroupModelUtils.checkComplexBannersConsistency;
import static ru.yandex.direct.core.entity.banner.service.validation.type.BannerTypeValidationPredicates.isTextBanner;
import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

public class ComplexBannerLogicSupplier<T extends ComplexAdGroup> extends BannerLogicSupplier<T, BannerWithSystemFields> {

    public ComplexBannerLogicSupplier(List<T> complexAdGroups,
                                      ModelProperty<? super T, List<ComplexBanner>> complexBannerProperty,
                                      Map<Long, AdGroupSimple> adGroupSimpleMap,
                                      BannersAddOperationFactory bannersAddOperationFactory,
                                      BannersUpdateOperationFactory bannersUpdateOperationFactory,
                                      VcardService vcardService, SitelinkSetService sitelinkSetService,
                                      long operatorUid, ClientId clientId, ModerationMode moderationMode) {
        super(complexAdGroups,
                ComplexBannerLogicSupplier.<T>modelsInterconnectionsFiller(complexBannerProperty, adGroupSimpleMap),
                ComplexBannerLogicSupplier.<T>bannerExecutorProvider(complexBannerProperty,
                        bannersAddOperationFactory, bannersUpdateOperationFactory, vcardService, sitelinkSetService,
                        operatorUid, clientId, moderationMode)
        );
        checkComplexBannersConsistency(complexAdGroups, complexBannerProperty);
    }

    private static <T extends ComplexAdGroup> Consumer<List<T>> modelsInterconnectionsFiller(
            ModelProperty<? super T, List<ComplexBanner>> complexBannerProperty,
            Map<Long, AdGroupSimple> adGroupSimpleMap) {
        return complexAdGroups -> {
            for (T complexAdGroup : complexAdGroups) {
                Long adGroupId = complexAdGroup.getAdGroup().getId();
                Long campaignId = ifNotNull(adGroupSimpleMap.get(adGroupId), AdGroupSimple::getCampaignId);

                List<ComplexBanner> complexBanners = complexBannerProperty.get(complexAdGroup);
                if (!isEmpty(complexBanners)) {
                    for (ComplexBanner complexBanner : complexBanners) {
                        var banner = complexBanner.getBanner();
                        banner.setAdGroupId(adGroupId);

                        if (isTextBanner(banner)) {
                            ((TextBanner) banner)
                                    .withSitelinksSetId(null)
                                    .withVcardId(null);
                        }

                        if (complexBanner.getVcard() != null) {
                            complexBanner.getVcard().withCampaignId(campaignId);
                        }
                    }
                }
            }
        };
    }

    private static <T extends ComplexAdGroup> Function<List<T>, ListSubOperationExecutor<AdGroup,
            BannerWithSystemFields, ? extends UpdateBannersSubOperation<BannerWithSystemFields>>>
    bannerExecutorProvider(
            ModelProperty<? super T, List<ComplexBanner>> complexBannerProperty,
            BannersAddOperationFactory bannersAddOperationFactory,
            BannersUpdateOperationFactory bannersUpdateOperationFactory,
            VcardService vcardService, SitelinkSetService sitelinkSetService,
            long operatorUid, ClientId clientId, ModerationMode moderationMode) {
        return complexAdGroups -> {
            SubOperationCreator<ComplexBanner, UpdateComplexBannersSubOperation> subOperationCreator =
                    banners -> new UpdateComplexBannersSubOperation(moderationMode, banners, bannersAddOperationFactory,
                            bannersUpdateOperationFactory, vcardService, sitelinkSetService,
                            operatorUid, clientId, false);

            return ListSubOperationExecutor.builder()
                    .withFakeParents(complexAdGroups)
                    .withFakeChildrenProperty(complexBannerProperty)
                    .withRealChildProperty(ComplexBanner.BANNER)
                    .createSubOperationBy(subOperationCreator);
        };
    }
}
