package ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.update;

import java.util.List;

import ru.yandex.direct.core.entity.adgroup.container.ComplexCpmAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.UsersSegmentsValidationUtil;
import ru.yandex.direct.core.entity.userssegments.service.UsersSegmentService;
import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.core.entity.adgroup.AdGroupWithUsersSegmentsHelper.complexCpmAdGroupsToMap;


public class CpmUsersSegmentsLogicSupplier extends UpdateSubEntityLogicSupplier<ComplexCpmAdGroup> {
    private final UsersSegmentService usersSegmentService;
    private final int shard;

    public CpmUsersSegmentsLogicSupplier(List<ComplexCpmAdGroup> complexAdGroups,
                                         UsersSegmentService usersSegmentService,
                                         int shardId) {
        super(complexAdGroups);
        this.shard = shardId;
        this.usersSegmentService = usersSegmentService;
    }

    @Override
    public void prepare(ValidationResult<List<AdGroup>, Defect> adGroupsResult) {
        UsersSegmentsValidationUtil.validateCpmUsersSegmentsOnUpdate(adGroupsResult, complexAdGroups);
    }

    @Override
    public void apply(MassResult<Long> updateAdGroupsResult) {
        if (complexAdGroups == null || complexAdGroups.isEmpty()) {
            return;
        }
        Long campaignId = complexAdGroups.get(0).getAdGroup().getCampaignId();
        usersSegmentService.updateAdGroupsSegments(shard, campaignId, complexCpmAdGroupsToMap(complexAdGroups));
    }
}
