package ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.update

import ru.yandex.direct.core.entity.adgroup.container.ComplexAdGroup
import ru.yandex.direct.core.entity.adgroup.model.AdGroup
import ru.yandex.direct.core.entity.adgroup.service.complex.ComplexAdGroupModelUtils.checkOfferRetargetingsConsistency
import ru.yandex.direct.core.entity.offerretargeting.model.OfferRetargeting
import ru.yandex.direct.core.entity.offerretargeting.repository.OfferRetargetingRepository
import ru.yandex.direct.core.entity.offerretargeting.service.OfferRetargetingService
import ru.yandex.direct.dbutil.model.ClientId
import ru.yandex.direct.model.ModelProperty
import ru.yandex.direct.operation.tree.ListSubOperationExecutor
import ru.yandex.direct.operation.tree.SubOperationCreator
import ru.yandex.direct.result.MassResult
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult

class OfferRetargetingLogicSupplier<T : ComplexAdGroup>(
    complexAdGroups: List<T>,
    val offerRetargetingProperty: ModelProperty<in T, List<OfferRetargeting>>,
    val affectedAdGroupIds: Set<Long>,
    val operatorUid: Long,
    val clientId: ClientId,
    val clientUid: Long,
    val shard: Int,
    val offerRetargetingService: OfferRetargetingService,
    val offerRetargetingRepository: OfferRetargetingRepository
) : UpdateSubEntityLogicSupplier<T>(complexAdGroups) {
    private val offerRetargetingExecutor: ListSubOperationExecutor<AdGroup, OfferRetargeting, UpdateOfferRetargetingsSubOperation>

    init {
        checkOfferRetargetingsConsistency(complexAdGroups, offerRetargetingProperty)
        fillAdGroupId(offerRetargetingProperty)
        val subOperationCreator = SubOperationCreator { offerRetargetings: List<OfferRetargeting> ->
            UpdateOfferRetargetingsSubOperation(
                offerRetargetingService,
                offerRetargetingRepository,
                offerRetargetings,
                operatorUid,
                clientId,
                clientUid,
                shard,
                affectedAdGroupIds
            )
        }
        offerRetargetingExecutor = ListSubOperationExecutor.builder()
            .withFakeParents(complexAdGroups)
            .withChildrenProperty(offerRetargetingProperty)
            .createSubOperationBy(subOperationCreator)
    }

    private fun fillAdGroupId(offerRetargetingProperty: ModelProperty<in T, List<OfferRetargeting>>) {
        for (complexAdGroup in complexAdGroups) {
            val adGroupId = complexAdGroup.adGroup.id
            val offerRetargetings = offerRetargetingProperty[complexAdGroup] ?: continue
            for (offerRetargeting in offerRetargetings) {
                offerRetargeting.adGroupId = adGroupId
            }
        }
    }

    override fun prepare(adGroupsResults: ValidationResult<List<AdGroup>, Defect<*>>) {
        offerRetargetingExecutor.prepare(adGroupsResults)
    }

    override fun apply(updateAdGroupsResult: MassResult<Long>) {
        offerRetargetingExecutor.apply()
    }
}
