package ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.update;

import java.util.List;

import ru.yandex.direct.core.entity.adgroup.container.ComplexAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.retargeting.model.RetargetingConditionBase;
import ru.yandex.direct.core.entity.retargeting.service.RetargetingConditionOperationFactory;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.operation.tree.ListSubOperationExecutor;
import ru.yandex.direct.operation.tree.SubOperationCreator;
import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

public class RetargetingConditionLogicSupplier<T extends ComplexAdGroup> extends UpdateSubEntityLogicSupplier<T> {
    private ListSubOperationExecutor<AdGroup, RetargetingConditionBase, UpdateRetargetingConditionsSubOperation>
            retargetingConditionExecutor;

    public RetargetingConditionLogicSupplier(List<T> complexAdGroups,
                                             ModelProperty<? super T, List<RetargetingConditionBase>> retargetingConditionProperty,
                                             RetargetingConditionOperationFactory retargetingConditionOperationFactory,
                                             ClientId clientId) {
        super(complexAdGroups);
        createRetargetingConditionExecutor(retargetingConditionProperty,
                retargetingConditionOperationFactory, clientId);
    }

    private void createRetargetingConditionExecutor(
            ModelProperty<? super T, List<RetargetingConditionBase>> retargetingConditionProperty,
            RetargetingConditionOperationFactory retargetingConditionOperationFactory, ClientId clientId) {
        SubOperationCreator<RetargetingConditionBase, UpdateRetargetingConditionsSubOperation> subOperationCreator =
                retargetingConditions -> new UpdateRetargetingConditionsSubOperation(
                        retargetingConditions,
                        retargetingConditionOperationFactory,
                        clientId
                );
        retargetingConditionExecutor = ListSubOperationExecutor.builder()
                .withFakeParents(complexAdGroups)
                .withChildrenProperty(retargetingConditionProperty)
                .createSubOperationBy(subOperationCreator);
    }

    @Override
    public void prepare(ValidationResult<List<AdGroup>, Defect> adGroupsResults) {
        retargetingConditionExecutor.prepare(adGroupsResults);
    }

    @Override
    public void apply(MassResult<Long> updateAdGroupsResult) {
        retargetingConditionExecutor.apply();
    }
}
