package ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.update;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.common.AddSitelinkSetsSubOperation;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.common.AddVcardsSubOperation;
import ru.yandex.direct.core.entity.banner.container.ComplexBanner;
import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields;
import ru.yandex.direct.core.entity.banner.service.BannersAddOperationFactory;
import ru.yandex.direct.core.entity.banner.service.BannersUpdateOperationFactory;
import ru.yandex.direct.core.entity.banner.service.DatabaseMode;
import ru.yandex.direct.core.entity.banner.service.moderation.ModerationMode;
import ru.yandex.direct.core.entity.sitelink.model.SitelinkSet;
import ru.yandex.direct.core.entity.sitelink.service.SitelinkSetService;
import ru.yandex.direct.core.entity.vcard.model.Vcard;
import ru.yandex.direct.core.entity.vcard.service.VcardService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.operation.tree.ItemSubOperationExecutor;
import ru.yandex.direct.operation.tree.SubOperationCreator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.core.entity.banner.service.validation.type.BannerTypeValidationPredicates.isTextBanner;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

/**
 * Сабоперация обновления баннеров с визитками и сайтлинками
 */
public class UpdateComplexBannersSubOperation extends UpdateBannersSubOperation<BannerWithSystemFields> {

    private ItemSubOperationExecutor<BannerWithSystemFields, Vcard, AddVcardsSubOperation> vcardExecutor;
    private ItemSubOperationExecutor<BannerWithSystemFields, SitelinkSet, AddSitelinkSetsSubOperation> sitelinkSetExecutor;

    @SuppressWarnings("WeakerAccess")
    public UpdateComplexBannersSubOperation(ModerationMode moderationMode, List<ComplexBanner> allComplexBanners,
                                            BannersAddOperationFactory bannersAddOperationFactory,
                                            BannersUpdateOperationFactory bannersUpdateOperationFactory,
                                            VcardService vcardService,
                                            SitelinkSetService sitelinkSetService, long operatorUid,
                                            ClientId clientId, boolean isUcPreValidation) {
        super(moderationMode, mapList(allComplexBanners, ComplexBanner::getBanner), bannersAddOperationFactory,
                bannersUpdateOperationFactory, operatorUid, clientId, isUcPreValidation, DatabaseMode.ONLY_MYSQL);

        createVcardExecutor(vcardService, allComplexBanners, operatorUid, clientId);
        createSitelinkExecutor(sitelinkSetService, allComplexBanners, clientId);
    }

    private void createVcardExecutor(VcardService vcardService,
                                     List<ComplexBanner> complexBanners, long operatorUid, ClientId clientId) {
        SubOperationCreator<Vcard, AddVcardsSubOperation> operationCreator =
                vcards -> new AddVcardsSubOperation(vcardService, vcards, operatorUid, clientId);
        vcardExecutor = ItemSubOperationExecutor.builder()
                .withFakeParents(complexBanners)
                .withChildProperty(ComplexBanner.VCARD)
                .withFiltering(complexBanner -> isTextBanner(complexBanner.getBanner()))
                .createSubOperationBy(operationCreator);
    }

    private void createSitelinkExecutor(SitelinkSetService sitelinkSetService,
                                        List<ComplexBanner> complexBanners, ClientId clientId) {
        SubOperationCreator<SitelinkSet, AddSitelinkSetsSubOperation> operationCreator =
                sitelinkSets -> new AddSitelinkSetsSubOperation(sitelinkSetService, sitelinkSets, clientId);
        sitelinkSetExecutor = ItemSubOperationExecutor.builder()
                .withFakeParents(complexBanners)
                .withChildProperty(ComplexBanner.SITELINK_SET)
                .withFiltering(complexBanner -> isTextBanner(complexBanner.getBanner()))
                .createSubOperationBy(operationCreator);
    }

    @Override
    protected void afterBannersPrepare(ValidationResult<List<BannerWithSystemFields>, Defect> validationResult) {
        vcardExecutor.prepare(validationResult);
        sitelinkSetExecutor.prepare(validationResult);
    }

    @Override
    protected void beforeBannersApply() {
        applyVcards();
        applySitelinkSets();
    }

    private void applyVcards() {
        vcardExecutor.apply();

        Map<Integer, Integer> vcardIndexMap = vcardExecutor.getIndexMap();
        var vcards = vcardExecutor.getSubOperation().getVcards();

        if (bannersAddOperation != null) {
            Map<Integer, Vcard> addedBannerIndexToVcardId =
                    getSubObjectIdsMap(addTextBannersIndexMap, vcardIndexMap, vcards);
            bannersAddOperation.setVcards(addedBannerIndexToVcardId);
        }

        if (bannersUpdateOperation != null) {
            Map<Integer, Vcard> updatedBannerIndexToVcardId =
                    getSubObjectIdsMap(updateTextBannersIndexMap, vcardIndexMap, vcards);
            bannersUpdateOperation.setVcards(updatedBannerIndexToVcardId);
        }
    }

    private void applySitelinkSets() {
        sitelinkSetExecutor.apply();

        Map<Integer, Integer> sitelinksSetIndexMap = sitelinkSetExecutor.getIndexMap();
        List<SitelinkSet> sitelinkSets = sitelinkSetExecutor.getSubOperation().getSitelinkSets();

        if (bannersAddOperation != null) {
            Map<Integer, SitelinkSet> addedBannerIndexToSitelinkSetId =
                    getSubObjectIdsMap(addTextBannersIndexMap, sitelinksSetIndexMap, sitelinkSets);
            bannersAddOperation.setSitelinkSets(addedBannerIndexToSitelinkSetId);
        }

        if (bannersUpdateOperation != null) {
            Map<Integer, SitelinkSet> updatedBannerIndexToSitelinkSetId =
                    getSubObjectIdsMap(updateTextBannersIndexMap, sitelinksSetIndexMap, sitelinkSets);
            bannersUpdateOperation.setSitelinkSets(updatedBannerIndexToSitelinkSetId);
        }
    }

    private static <T> Map<Integer, T> getSubObjectIdsMap(Map<Integer, Integer> bannerIndexMap,
                                                          Map<Integer, Integer> subObjectIndexMap,
                                                          List<T> subObjectIds) {
        Map<Integer, T> subObjectIdsMap = new HashMap<>();
        bannerIndexMap.forEach((bannerIndex, subBannerIndex) -> {
            Integer subObjectIndex = subObjectIndexMap.get(bannerIndex);
            T subObjectId = subObjectIndex != null ? subObjectIds.get(subObjectIndex) : null;
            subObjectIdsMap.put(subBannerIndex, subObjectId);
        });
        return subObjectIdsMap;
    }
}
