package ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.update

import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.update.converter.OfferRetargetingUpdateConverter.offerRetargetingToModelChanges
import ru.yandex.direct.core.entity.offerretargeting.container.OfferRetargetingModification.OFFER_RETARGETING_ADD
import ru.yandex.direct.core.entity.offerretargeting.container.OfferRetargetingModification.OFFER_RETARGETING_UPDATE
import ru.yandex.direct.core.entity.offerretargeting.container.OfferRetargetingModificationResult
import ru.yandex.direct.core.entity.offerretargeting.model.OfferRetargeting
import ru.yandex.direct.core.entity.offerretargeting.repository.OfferRetargetingMapping.createOfferRetargetingModification
import ru.yandex.direct.core.entity.offerretargeting.repository.OfferRetargetingRepository
import ru.yandex.direct.core.entity.offerretargeting.service.OfferRetargetingModifyOperation
import ru.yandex.direct.core.entity.offerretargeting.service.OfferRetargetingService
import ru.yandex.direct.dbutil.model.ClientId
import ru.yandex.direct.model.ModelChanges
import ru.yandex.direct.operation.tree.ItemSubOperationExecutor.extractSubList
import ru.yandex.direct.operation.tree.SubOperation
import ru.yandex.direct.operation.tree.TreeOperationUtils.mergeSubListValidationResults
import ru.yandex.direct.result.Result
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.PathHelper.field
import ru.yandex.direct.validation.result.ValidationResult

class UpdateOfferRetargetingsSubOperation(
    private val offerRetargetingService: OfferRetargetingService,
    offerRetargetingRepository: OfferRetargetingRepository,
    private val offerRetargetings: List<OfferRetargeting>,
    private val operatorUid: Long,
    private val clientId: ClientId,
    private val clientUid: Long,
    shard: Int,
    affectedAdGroupIds: Set<Long>
) : SubOperation<OfferRetargeting> {
    /**
     * Соответствие индексов в списке offerRetargetings с индексами в списке создаваемых офферных ретаргетингов
     */
    private val addIndexMap: Map<Int, Int>

    /**
     * Соответствие индексов в списке offerRetargetings с индексами в списке обновляемых офферных ретаргетингов
     */
    private val updateIndexMap: Map<Int, Int>
    private val offerRetargetingModifyOperation: OfferRetargetingModifyOperation?

    init {
        // заполняем список add и addIndexMap
        val addIndexMap = mutableMapOf<Int, Int>()
        val offerRetargetingsToAdd = extractSubList(addIndexMap, offerRetargetings) { it.id == null }
        this.addIndexMap = addIndexMap

        // заполняем список update и updateIndexMap
        val updateIndexMap = mutableMapOf<Int, Int>()
        val offerRetargetingsToUpdate = extractSubList(updateIndexMap, offerRetargetings, { it.id != null }) {
            offerRetargetingToModelChanges(it)
        }
        this.updateIndexMap = updateIndexMap

        // заполняем список delete
        val offerRetargetingsByAdGroupIds = offerRetargetingRepository
            .getOfferRetargetingIdsByAdGroupIds(shard, clientId, affectedAdGroupIds)
        val offerRetargetingIdsToUpdate: Set<Long> = offerRetargetingsToUpdate.mapTo(mutableSetOf()) { it.id }
        val offerRetargetingIdsToDelete = offerRetargetingsByAdGroupIds.values.asSequence()
            .flatten()
            .filterNot { it in offerRetargetingIdsToUpdate }
            .toList()

        // создаем операцию
        offerRetargetingModifyOperation = createModifyOperation(
            offerRetargetingsToAdd,
            offerRetargetingsToUpdate,
            offerRetargetingIdsToDelete
        )
    }

    override fun prepare(): ValidationResult<List<OfferRetargeting>, Defect<Any>> {
        val validationResult = ValidationResult<List<OfferRetargeting>, Defect<Any>>(offerRetargetings)

        val result = offerRetargetingModifyOperation?.prepare() ?: return validationResult
        mergeValidationResults(result, validationResult)

        return validationResult
    }

    private fun createModifyOperation(
        offerRetargetingsToAdd: List<OfferRetargeting>,
        offerRetargetingsToUpdate: List<ModelChanges<OfferRetargeting>>,
        offerRetargetingIdsToDelete: List<Long>
    ): OfferRetargetingModifyOperation? =
        if (offerRetargetingsToAdd.isEmpty() && offerRetargetingsToUpdate.isEmpty() && offerRetargetingIdsToDelete.isEmpty()) {
            null
        } else {
            val modification = createOfferRetargetingModification(
                offerRetargetingsToAdd,
                offerRetargetingsToUpdate,
                offerRetargetingIdsToDelete
            )
            offerRetargetingService.createFullModifyOperation(clientId, clientUid, operatorUid, modification)
        }

    @Suppress("UNCHECKED_CAST")
    private fun mergeValidationResults(
        result: Result<OfferRetargetingModificationResult>,
        destValidationResult: ValidationResult<List<OfferRetargeting>, Defect<Any>>
    ) {
        val entireValidationResult = result.validationResult
        val validationResultsAdd = entireValidationResult.subResults[field(OFFER_RETARGETING_ADD.name())]
            as ValidationResult<List<OfferRetargeting>, Defect<Any>>?
        val validationResultsUpdate = entireValidationResult.subResults[field(OFFER_RETARGETING_UPDATE.name())]
            as ValidationResult<List<OfferRetargeting>, Defect<Any>>?

        mergeSubListValidationResults(destValidationResult, validationResultsAdd, addIndexMap)
        mergeSubListValidationResults(destValidationResult, validationResultsUpdate, updateIndexMap)
    }

    override fun apply() {
        offerRetargetingModifyOperation?.apply()
    }
}
