package ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.update;

import java.util.List;

import ru.yandex.direct.core.entity.retargeting.model.RetargetingCondition;
import ru.yandex.direct.core.entity.retargeting.model.RetargetingConditionBase;
import ru.yandex.direct.core.entity.retargeting.service.RetargetingConditionOperationFactory;
import ru.yandex.direct.core.entity.retargeting.service.RetargetingConditionsUpdateOperation;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.operation.Applicability;
import ru.yandex.direct.operation.tree.SubOperation;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.operation.tree.TreeOperationUtils.prepareNullableOperationAndGetValidationResult;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

public class UpdateRetargetingConditionsSubOperation implements SubOperation<RetargetingConditionBase> {

    private final RetargetingConditionOperationFactory retargetingConditionOperationFactory;
    private final List<RetargetingConditionBase> retargetingConditions;

    private final ClientId clientId;

    private RetargetingConditionsUpdateOperation retargetingConditionsUpdateOperation;

    public UpdateRetargetingConditionsSubOperation(
            List<RetargetingConditionBase> retargetingConditions,
            RetargetingConditionOperationFactory retargetingConditionOperationFactory,
            ClientId clientId) {
        this.retargetingConditionOperationFactory = retargetingConditionOperationFactory;
        this.retargetingConditions = retargetingConditions;
        this.clientId = clientId;
    }

    static ModelChanges<RetargetingCondition> retargetingConditionToModelChanges(
            RetargetingConditionBase retargetingCondition) {
        return new ModelChanges<>(retargetingCondition.getId(), RetargetingCondition.class)
                .process(retargetingCondition.getName(), RetargetingCondition.NAME)
                .process(retargetingCondition.getDescription(), RetargetingCondition.DESCRIPTION)
                .process(retargetingCondition.getRules(), RetargetingCondition.RULES);
    }

    @Override
    public ValidationResult<List<RetargetingConditionBase>, Defect> prepare() {
        List<ModelChanges<RetargetingCondition>> changesList = mapList(retargetingConditions,
                UpdateRetargetingConditionsSubOperation::retargetingConditionToModelChanges);

        if (!changesList.isEmpty()) {
            retargetingConditionsUpdateOperation = retargetingConditionOperationFactory
                    .createUpdateOperation(Applicability.FULL, changesList, clientId, true, true);
        }

        return prepareNullableOperationAndGetValidationResult(retargetingConditionsUpdateOperation,
                retargetingConditions);
    }

    @Override
    public void apply() {
        if (retargetingConditionsUpdateOperation != null) {
            retargetingConditionsUpdateOperation.apply();
        }
    }
}
