package ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.update.converter;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields;
import ru.yandex.direct.core.entity.banner.model.ContentPromotionBanner;
import ru.yandex.direct.core.entity.banner.model.CpcVideoBanner;
import ru.yandex.direct.core.entity.banner.model.CpmAudioBanner;
import ru.yandex.direct.core.entity.banner.model.CpmBanner;
import ru.yandex.direct.core.entity.banner.model.CpmGeoPinBanner;
import ru.yandex.direct.core.entity.banner.model.CpmIndoorBanner;
import ru.yandex.direct.core.entity.banner.model.CpmOutdoorBanner;
import ru.yandex.direct.core.entity.banner.model.DynamicBanner;
import ru.yandex.direct.core.entity.banner.model.ImageBanner;
import ru.yandex.direct.core.entity.banner.model.McBanner;
import ru.yandex.direct.core.entity.banner.model.MobileAppBanner;
import ru.yandex.direct.core.entity.banner.model.PerformanceBannerMain;
import ru.yandex.direct.core.entity.banner.model.TextBanner;
import ru.yandex.direct.model.ModelChanges;

import static java.lang.String.format;
import static ru.yandex.direct.core.entity.banner.service.validation.type.BannerTypeValidationPredicates.isContentPromotionBanner;
import static ru.yandex.direct.core.entity.banner.service.validation.type.BannerTypeValidationPredicates.isCpcVideoBanner;
import static ru.yandex.direct.core.entity.banner.service.validation.type.BannerTypeValidationPredicates.isCpmAudioBanner;
import static ru.yandex.direct.core.entity.banner.service.validation.type.BannerTypeValidationPredicates.isCpmBanner;
import static ru.yandex.direct.core.entity.banner.service.validation.type.BannerTypeValidationPredicates.isCpmGeoPinBanner;
import static ru.yandex.direct.core.entity.banner.service.validation.type.BannerTypeValidationPredicates.isCpmIndoorBanner;
import static ru.yandex.direct.core.entity.banner.service.validation.type.BannerTypeValidationPredicates.isCpmOutdoorBanner;
import static ru.yandex.direct.core.entity.banner.service.validation.type.BannerTypeValidationPredicates.isDynamicBanner;
import static ru.yandex.direct.core.entity.banner.service.validation.type.BannerTypeValidationPredicates.isImageBanner;
import static ru.yandex.direct.core.entity.banner.service.validation.type.BannerTypeValidationPredicates.isMcBannerBanner;
import static ru.yandex.direct.core.entity.banner.service.validation.type.BannerTypeValidationPredicates.isMobileAppBanner;
import static ru.yandex.direct.core.entity.banner.service.validation.type.BannerTypeValidationPredicates.isPerformanceBannerMain;
import static ru.yandex.direct.core.entity.banner.service.validation.type.BannerTypeValidationPredicates.isTextBanner;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@ParametersAreNonnullByDefault
public class ComplexBannerUpdateConverter {

    private ComplexBannerUpdateConverter() {
        // no instantiation
    }

    public static List<ModelChanges<BannerWithSystemFields>> bannersToCoreModelChanges(
            List<? extends BannerWithSystemFields> complexBanners) {
        return mapList(complexBanners, ComplexBannerUpdateConverter::bannerToCoreModelChanges);
    }

    static ModelChanges<BannerWithSystemFields> bannerToCoreModelChanges(BannerWithSystemFields banner) {
        final ModelChanges<BannerWithSystemFields> result;

        if (isTextBanner(banner)) {
            result = toModelChanges((TextBanner) banner);
        } else if (isImageBanner(banner)) {
            result = toModelChanges((ImageBanner) banner);
        } else if (isCpcVideoBanner(banner)) {
            result = toModelChanges((CpcVideoBanner) banner);
        } else if (isCpmBanner(banner)) {
            result = toModelChanges((CpmBanner) banner);
        } else if (isCpmAudioBanner(banner)) {
            result = toModelChanges((CpmAudioBanner) banner);
        } else if (isCpmOutdoorBanner(banner)) {
            result = toModelChanges((CpmOutdoorBanner) banner);
        } else if (isCpmIndoorBanner(banner)) {
            result = toModelChanges((CpmIndoorBanner) banner);
        } else if (isCpmGeoPinBanner(banner)) {
            result = toModelChanges((CpmGeoPinBanner) banner);
        } else if (isContentPromotionBanner(banner)) {
            result = toModelChanges((ContentPromotionBanner) banner);
        } else if (isMcBannerBanner(banner)) {
            result = toModelChanges((McBanner) banner);
        } else if (isMobileAppBanner(banner)) {
            result = toModelChanges((MobileAppBanner) banner);
        } else if (isPerformanceBannerMain(banner)) {
            result = toModelChanges((PerformanceBannerMain) banner);
        } else if (isDynamicBanner(banner)) {
            result = toModelChanges((DynamicBanner) banner);
        } else {
            throw new UnsupportedOperationException(
                    format("Banners of type %s are not supported.", banner.getClass()));
        }
        return result;
    }

    private static ModelChanges<BannerWithSystemFields> toModelChanges(TextBanner banner) {
        return new ModelChanges<>(banner.getId(), TextBanner.class)
                .process(banner.getTitle(), TextBanner.TITLE)
                .process(banner.getTitleExtension(), TextBanner.TITLE_EXTENSION)
                .process(banner.getBody(), TextBanner.BODY)
                .process(banner.getHref(), TextBanner.HREF)
                .processNotNull(banner.getDomain(), TextBanner.DOMAIN)
                .process(banner.getDisplayHref(), TextBanner.DISPLAY_HREF)

                .process(banner.getImageHash(), TextBanner.IMAGE_HASH)
                .process(banner.getImageStatusShow(), TextBanner.IMAGE_STATUS_SHOW)
                .process(banner.getImageName(), TextBanner.IMAGE_NAME)
                .process(banner.getImageStatusModerate(), TextBanner.IMAGE_STATUS_MODERATE)

                .process(banner.getCreativeId(), TextBanner.CREATIVE_ID)
                .process(banner.getCalloutIds(), TextBanner.CALLOUT_IDS)
                .process(banner.getBannerPrice(), TextBanner.BANNER_PRICE)
                .process(banner.getTurboLandingHrefParams(), TextBanner.TURBO_LANDING_HREF_PARAMS)
                .process(banner.getTurboLandingId(), TextBanner.TURBO_LANDING_ID)
                .castModelUp(BannerWithSystemFields.class);
    }

    private static ModelChanges<BannerWithSystemFields> toModelChanges(ImageBanner banner) {
        return new ModelChanges<>(banner.getId(), ImageBanner.class)
                .process(banner.getIsMobileImage(), ImageBanner.IS_MOBILE_IMAGE)
                .process(banner.getHref(), ImageBanner.HREF)
                .processNotNull(banner.getDomain(), ImageBanner.DOMAIN)
                .process(banner.getImageHash(), ImageBanner.IMAGE_HASH)
                .process(banner.getImageStatusModerate(), ImageBanner.IMAGE_STATUS_MODERATE)
                .process(banner.getCreativeId(), ImageBanner.CREATIVE_ID)
                .process(banner.getTurboLandingHrefParams(), ImageBanner.TURBO_LANDING_HREF_PARAMS)
                .process(banner.getTurboLandingId(), ImageBanner.TURBO_LANDING_ID)
                .castModelUp(BannerWithSystemFields.class);
    }

    private static ModelChanges<BannerWithSystemFields> toModelChanges(CpcVideoBanner banner) {
        return new ModelChanges<>(banner.getId(), CpcVideoBanner.class)
                .process(banner.getIsMobileVideo(), CpcVideoBanner.IS_MOBILE_VIDEO)
                .process(banner.getHref(), CpcVideoBanner.HREF)
                .processNotNull(banner.getDomain(), CpcVideoBanner.DOMAIN)
                .process(banner.getCreativeId(), CpcVideoBanner.CREATIVE_ID)
                .process(banner.getTurboLandingHrefParams(), CpcVideoBanner.TURBO_LANDING_HREF_PARAMS)
                .process(banner.getTurboLandingId(), CpcVideoBanner.TURBO_LANDING_ID)
                .castModelUp(BannerWithSystemFields.class);
    }

    private static ModelChanges<BannerWithSystemFields> toModelChanges(CpmBanner banner) {
        return new ModelChanges<>(banner.getId(), CpmBanner.class)
                .process(banner.getHref(), CpmBanner.HREF)
                .processNotNull(banner.getDomain(), CpmBanner.DOMAIN)
                .process(banner.getCreativeId(), CpmBanner.CREATIVE_ID)
                .process(banner.getPixels(), CpmBanner.PIXELS)
                .process(banner.getTurboLandingHrefParams(), CpmBanner.TURBO_LANDING_HREF_PARAMS)
                .process(banner.getTurboLandingId(), CpmBanner.TURBO_LANDING_ID)
                .process(banner.getMeasurers(), CpmBanner.MEASURERS)
                .process(banner.getTnsId(), CpmBanner.TNS_ID)
                .castModelUp(BannerWithSystemFields.class);
    }

    private static ModelChanges<BannerWithSystemFields> toModelChanges(CpmAudioBanner banner) {
        return new ModelChanges<>(banner.getId(), CpmAudioBanner.class)
                .process(banner.getHref(), CpmAudioBanner.HREF)
                .processNotNull(banner.getDomain(), CpmAudioBanner.DOMAIN)
                .process(banner.getCreativeId(), CpmAudioBanner.CREATIVE_ID)
                .process(banner.getPixels(), CpmAudioBanner.PIXELS)
                .process(banner.getMeasurers(), CpmAudioBanner.MEASURERS)
                .castModelUp(BannerWithSystemFields.class);
    }

    private static ModelChanges<BannerWithSystemFields> toModelChanges(CpmGeoPinBanner banner) {
        return new ModelChanges<>(banner.getId(), CpmGeoPinBanner.class)
                .process(banner.getCreativeId(), CpmGeoPinBanner.CREATIVE_ID)
                .process(banner.getPixels(), CpmGeoPinBanner.PIXELS)
                .process(banner.getMeasurers(), CpmGeoPinBanner.MEASURERS)
                .process(banner.getPermalinkId(), CpmGeoPinBanner.PERMALINK_ID)
                .castModelUp(BannerWithSystemFields.class);
    }

    private static ModelChanges<BannerWithSystemFields> toModelChanges(McBanner banner) {
        return new ModelChanges<>(banner.getId(), McBanner.class)
                .process(banner.getHref(), McBanner.HREF)
                .processNotNull(banner.getDomain(), McBanner.DOMAIN)
                .process(banner.getImageHash(), McBanner.IMAGE_HASH)
                .process(banner.getImageStatusModerate(), McBanner.IMAGE_STATUS_MODERATE)
                .castModelUp(BannerWithSystemFields.class);
    }

    private static ModelChanges<BannerWithSystemFields> toModelChanges(MobileAppBanner banner) {
        return new ModelChanges<>(banner.getId(), MobileAppBanner.class)
                .process(banner.getHref(), MobileAppBanner.HREF)
                .process(banner.getBody(), MobileAppBanner.BODY)

                .process(banner.getImageHash(), TextBanner.IMAGE_HASH)
                .process(banner.getImageStatusShow(), TextBanner.IMAGE_STATUS_SHOW)
                .process(banner.getImageName(), TextBanner.IMAGE_NAME)
                .process(banner.getImageStatusModerate(), TextBanner.IMAGE_STATUS_MODERATE)
                .process(banner.getCreativeId(), TextBanner.CREATIVE_ID)

                .process(banner.getPrimaryAction(), MobileAppBanner.PRIMARY_ACTION)
                .process(banner.getReflectedAttributes(), MobileAppBanner.REFLECTED_ATTRIBUTES)
                .process(banner.getImpressionUrl(), MobileAppBanner.IMPRESSION_URL)
                .process(banner.getTitle(), MobileAppBanner.TITLE)
                .processNotNull(banner.getDomain(), MobileAppBanner.DOMAIN)
                .castModelUp(BannerWithSystemFields.class);
    }

    private static ModelChanges<BannerWithSystemFields> toModelChanges(PerformanceBannerMain banner) {
        return new ModelChanges<>(banner.getId(), PerformanceBannerMain.class)
                .process(banner.getLogoImageHash(), PerformanceBannerMain.LOGO_IMAGE_HASH)
                .castModelUp(BannerWithSystemFields.class);
    }

    private static ModelChanges<BannerWithSystemFields> toModelChanges(DynamicBanner banner) {
        return new ModelChanges<>(banner.getId(), DynamicBanner.class)
                .process(banner.getHref(), DynamicBanner.HREF)
                .process(banner.getBody(), DynamicBanner.BODY)
                .castModel(BannerWithSystemFields.class);
    }

    /**
     * Пока cpm_outdoor-баннеры иммутабельны
     */
    private static ModelChanges<BannerWithSystemFields> toModelChanges(CpmOutdoorBanner banner) {
        return new ModelChanges<>(banner.getId(), CpmOutdoorBanner.class)
                .castModelUp(BannerWithSystemFields.class);
    }

    private static ModelChanges<BannerWithSystemFields> toModelChanges(CpmIndoorBanner banner) {
        return new ModelChanges<>(banner.getId(), CpmIndoorBanner.class)
                .processNotNull(banner.getDomain(), CpmIndoorBanner.DOMAIN)
                .process(banner.getHref(), CpmIndoorBanner.HREF)
                .process(banner.getCreativeId(), CpmIndoorBanner.CREATIVE_ID)
                .castModelUp(BannerWithSystemFields.class);
    }

    private static ModelChanges<BannerWithSystemFields> toModelChanges(ContentPromotionBanner banner) {
        return new ModelChanges<>(banner.getId(), ContentPromotionBanner.class)
                .process(banner.getBody(), ContentPromotionBanner.BODY)
                .process(banner.getTitle(), ContentPromotionBanner.TITLE)
                .process(banner.getContentPromotionId(), ContentPromotionBanner.CONTENT_PROMOTION_ID)
                .process(banner.getVisitUrl(), ContentPromotionBanner.VISIT_URL)
                .castModelUp(BannerWithSystemFields.class);
    }
}
