package ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.update.converter;

import ru.yandex.direct.core.entity.keyword.model.Keyword;
import ru.yandex.direct.model.ModelChanges;

public class KeywordUpdateConverter {

    private KeywordUpdateConverter() {
    }

    public static ModelChanges<Keyword> keywordToModelChanges(Keyword keyword) {
        return new ModelChanges<>(keyword.getId(), Keyword.class)
                .processNotNull(keyword.getPhrase(), Keyword.PHRASE)
                .processNotNull(keyword.getPrice(), Keyword.PRICE)
                .processNotNull(keyword.getPriceContext(), Keyword.PRICE_CONTEXT)
                .processNotNull(keyword.getIsSuspended(), Keyword.IS_SUSPENDED)
                .processNotNull(keyword.getAutobudgetPriority(), Keyword.AUTOBUDGET_PRIORITY);
    }
}
