package ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.update.converter;

import java.util.List;

import ru.yandex.direct.core.entity.retargeting.model.Retargeting;
import ru.yandex.direct.model.ModelChanges;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

public class RetargetingsUpdateConverter {

    private RetargetingsUpdateConverter() {
    }

    public static List<ModelChanges<Retargeting>> retargetingsToCoreModelChanges(List<Retargeting> retargetings) {
        return mapList(retargetings, RetargetingsUpdateConverter::retargetingToCoreModelChanges);
    }

    private static ModelChanges<Retargeting> retargetingToCoreModelChanges(Retargeting retargeting) {
        return new ModelChanges<>(retargeting.getId(), Retargeting.class)
                .process(retargeting.getRetargetingConditionId(), Retargeting.RETARGETING_CONDITION_ID);
    }
}
