package ru.yandex.direct.core.entity.adgroup.service.complex.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import javax.annotation.Nullable;

import ru.yandex.direct.core.entity.adgroup.container.ComplexTextAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.adgroup.service.AdGroupService;
import ru.yandex.direct.core.entity.adgroup.service.complex.ComplexAdGroupAddOperation;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.add.AddSubEntityLogicSupplier;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.add.BidModifiersLogicSupplier;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.add.ComplexBannersLogicSupplier;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.add.KeywordLogicSupplier;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.add.OfferRetargetingLogicSupplier;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.add.RelevanceMatchLogicSupplier;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.add.RetargetingLogicSupplier;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.update.AddUpdateRetargetingConditionLogicSupplier;
import ru.yandex.direct.core.entity.banner.container.ComplexBanner;
import ru.yandex.direct.core.entity.banner.service.BannersAddOperationFactory;
import ru.yandex.direct.core.entity.banner.service.DatabaseMode;
import ru.yandex.direct.core.entity.bidmodifiers.service.BidModifierService;
import ru.yandex.direct.core.entity.bidmodifiers.service.ComplexBidModifierService;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.core.entity.client.service.ClientService;
import ru.yandex.direct.core.entity.keyword.service.KeywordOperationFactory;
import ru.yandex.direct.core.entity.offerretargeting.service.OfferRetargetingService;
import ru.yandex.direct.core.entity.relevancematch.service.RelevanceMatchService;
import ru.yandex.direct.core.entity.retargeting.service.RetargetingConditionOperationFactory;
import ru.yandex.direct.core.entity.retargeting.service.RetargetingService;
import ru.yandex.direct.core.entity.showcondition.container.ShowConditionAutoPriceParams;
import ru.yandex.direct.core.entity.showcondition.container.ShowConditionFixedAutoPrices;
import ru.yandex.direct.core.entity.sitelink.service.SitelinkSetService;
import ru.yandex.direct.core.entity.vcard.service.VcardService;
import ru.yandex.direct.currency.Currency;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.operation.Applicability;
import ru.yandex.direct.regions.GeoTree;
import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkState;

public class ComplexTextAdGroupAddOperation extends ComplexAdGroupAddOperation<ComplexTextAdGroup> {

    private final AddComplexTextAdGroupValidationService addValidationService;

    private final ComplexBannersLogicSupplier<ComplexTextAdGroup> bannersLogicSupplier;
    private final AddUpdateRetargetingConditionLogicSupplier<ComplexTextAdGroup> retargetingConditionLogicSupplier;
    private final List<AddSubEntityLogicSupplier<ComplexTextAdGroup>> suppliers;

    /**
     * @param showConditionAutoPrices      включает режим автоматического вычисления недостающих ставок в условиях
     *                                     показов
     * @param showConditionAutoPriceParams параметры для автоматического вычисления недостающих ставок в условиях
     *                                     показов. Должен быть не {@code null},
     *                                     если {@code showConditionAutoPrices == true}
     */
    public ComplexTextAdGroupAddOperation(boolean saveDraft,
                                          ClientService clientService,
                                          AdGroupService adGroupService,
                                          KeywordOperationFactory keywordOperationFactory,
                                          BannersAddOperationFactory bannersAddOperationFactory,
                                          VcardService vcardService, SitelinkSetService sitelinkSetService,
                                          RelevanceMatchService relevanceMatchService,
                                          OfferRetargetingService offerRetargetingService,
                                          RetargetingService retargetingService,
                                          BidModifierService bidModifierService,
                                          ComplexBidModifierService complexBidModifierService,
                                          AddComplexTextAdGroupValidationService addValidationService,
                                          CampaignRepository campaignRepository,
                                          RetargetingConditionOperationFactory retargetingConditionOperationFactory,
                                          List<ComplexTextAdGroup> complexAdGroups, GeoTree geoTree,
                                          boolean showConditionAutoPrices,
                                          @Nullable ShowConditionAutoPriceParams showConditionAutoPriceParams,
                                          long operatorUid, ClientId clientId, long clientUid, int shard,
                                          DatabaseMode databaseMode) {
        super(Applicability.FULL, saveDraft, adGroupService, complexAdGroups, geoTree, operatorUid, clientId, true);
        this.addValidationService = addValidationService;

        ShowConditionFixedAutoPrices showConditionFixedAutoPrices = null;
        if (showConditionAutoPrices) {
            checkArgument(showConditionAutoPriceParams != null,
                    "showConditionAutoPriceParams must be specified in showConditionAutoPrices mode");
            showConditionFixedAutoPrices = showConditionAutoPriceParams.getFixedAutoPrices();
        }

        Currency clientCurrency = clientService.getWorkCurrency(clientId);

        ArrayList<AddSubEntityLogicSupplier<ComplexTextAdGroup>> suppliersList = new ArrayList<>();
        bannersLogicSupplier = new ComplexBannersLogicSupplier<>(complexAdGroups, ComplexTextAdGroup.COMPLEX_BANNERS,
                ComplexBanner.BANNER, bannersAddOperationFactory, vcardService, sitelinkSetService,
                operatorUid, clientId, saveDraft, databaseMode);

        suppliersList.add(
                new KeywordLogicSupplier<>(complexAdGroups, ComplexTextAdGroup.KEYWORDS,
                        keywordOperationFactory, showConditionAutoPrices, showConditionFixedAutoPrices,
                        operatorUid, clientId, clientUid)
        );
        suppliersList.add(
                new OfferRetargetingLogicSupplier<>(complexAdGroups, ComplexTextAdGroup.OFFER_RETARGETINGS,
                        campaignRepository, offerRetargetingService, clientCurrency, operatorUid, clientId, shard)
        );
        suppliersList.add(
                new RelevanceMatchLogicSupplier<>(complexAdGroups, ComplexTextAdGroup.RELEVANCE_MATCHES,
                        campaignRepository, relevanceMatchService, clientCurrency,
                        showConditionAutoPrices, showConditionAutoPriceParams, operatorUid, clientId, shard)
        );
        suppliersList.add(
                new RetargetingLogicSupplier<>(complexAdGroups, Collections.emptyMap(),
                        ComplexTextAdGroup.TARGET_INTERESTS, retargetingService, campaignRepository, false,
                        showConditionAutoPrices, showConditionFixedAutoPrices, operatorUid, clientId, clientUid, shard)
        );
        suppliersList.add(
                new BidModifiersLogicSupplier<>(complexAdGroups, ComplexTextAdGroup.COMPLEX_BID_MODIFIER,
                        campaignRepository, bidModifierService, complexBidModifierService, operatorUid, clientId,
                        shard)
        );
        retargetingConditionLogicSupplier =
                new AddUpdateRetargetingConditionLogicSupplier<>(complexAdGroups,
                        ComplexTextAdGroup.RETARGETING_CONDITION, retargetingConditionOperationFactory, clientId);
        suppliers = suppliersList;
    }

    @Override
    protected void afterAdGroupsPrepare(ValidationResult<List<AdGroup>, Defect> adGroupsResult) {
        validateInterconnections(adGroupsResult);

        retargetingConditionLogicSupplier.prepare(adGroupsResult);
        bannersLogicSupplier.prepare(adGroupsResult);
        for (var supplier : suppliers) {
            supplier.prepare(adGroupsResult);
        }
    }

    private void validateInterconnections(ValidationResult<List<AdGroup>, Defect> adGroupsResult) {
        ValidationResult<List<AdGroup>, Defect> complexAdGroupsResult =
                addValidationService.validateAdGroups(adGroupsResult, complexAdGroups, clientId);
        checkState(!complexAdGroupsResult.hasErrors() && !complexAdGroupsResult.hasWarnings(),
                "AddComplexAdGroupValidationService must not return operational errors or warnings");
    }

    @Override
    protected void afterAdGroupsApply(MassResult<Long> addAdGroupsResult) {
        retargetingConditionLogicSupplier.apply(addAdGroupsResult);
        bannersLogicSupplier.apply(addAdGroupsResult);
        // Применение ключевых фраз должно осуществляться только после применения баннеров,
        // так как внутри осуществляется извлечение из базы баннеров для похода в торги.
        // Потенциальная точка рефакторинга.
        for (var supplier : suppliers) {
            supplier.apply(addAdGroupsResult);
        }
    }
}
