package ru.yandex.direct.core.entity.adgroup.service.complex.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

import javax.annotation.Nullable;

import ru.yandex.direct.core.entity.adgroup.container.ComplexTextAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.adgroup.repository.AdGroupRepository;
import ru.yandex.direct.core.entity.adgroup.service.AdGroupService;
import ru.yandex.direct.core.entity.adgroup.service.complex.ComplexAdGroupUpdateOperation;
import ru.yandex.direct.core.entity.adgroup.service.complex.UpdateComplexAdGroupValidationService;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.update.AddUpdateRetargetingConditionLogicSupplier;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.update.BidModifierLogicSupplier;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.update.ComplexBannerLogicSupplier;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.update.KeywordLogicSupplier;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.update.OfferRetargetingLogicSupplier;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.update.RelevanceMatchLogicSupplier;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.update.RetargetingLogicSupplier;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.update.UpdateSubEntityLogicSupplier;
import ru.yandex.direct.core.entity.banner.service.BannersAddOperationFactory;
import ru.yandex.direct.core.entity.banner.service.BannersUpdateOperationFactory;
import ru.yandex.direct.core.entity.bidmodifiers.service.BidModifierService;
import ru.yandex.direct.core.entity.bidmodifiers.service.ComplexBidModifierService;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.core.entity.keyword.repository.KeywordRepository;
import ru.yandex.direct.core.entity.keyword.service.KeywordModifyOperationFactory;
import ru.yandex.direct.core.entity.offerretargeting.repository.OfferRetargetingRepository;
import ru.yandex.direct.core.entity.offerretargeting.service.OfferRetargetingService;
import ru.yandex.direct.core.entity.relevancematch.repository.RelevanceMatchRepository;
import ru.yandex.direct.core.entity.relevancematch.service.RelevanceMatchService;
import ru.yandex.direct.core.entity.retargeting.service.RetargetingConditionOperationFactory;
import ru.yandex.direct.core.entity.retargeting.service.RetargetingService;
import ru.yandex.direct.core.entity.showcondition.container.ShowConditionAutoPriceParams;
import ru.yandex.direct.core.entity.showcondition.container.ShowConditionFixedAutoPrices;
import ru.yandex.direct.core.entity.sitelink.service.SitelinkSetService;
import ru.yandex.direct.core.entity.vcard.service.VcardService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.operation.Applicability;
import ru.yandex.direct.regions.GeoTree;
import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkState;
import static ru.yandex.direct.core.entity.adgroup.container.ComplexTextAdGroup.OFFER_RETARGETINGS;
import static ru.yandex.direct.core.entity.adgroup.container.ComplexTextAdGroup.RELEVANCE_MATCHES;
import static ru.yandex.direct.core.entity.adgroup.container.ComplexTextAdGroup.TARGET_INTERESTS;

public class ComplexTextAdGroupUpdateOperation extends ComplexAdGroupUpdateOperation<ComplexTextAdGroup> {

    private final UpdateComplexTextAdGroupValidationService updateValidationService;

    private final ComplexBannerLogicSupplier<ComplexTextAdGroup> bannersLogicSupplier;

    private final List<UpdateSubEntityLogicSupplier<ComplexTextAdGroup>> suppliers;

    private final ClientId clientId;

    /**
     * @param showConditionAutoPrices      включает режим автоматического вычисления недостающих ставок в условиях
     *                                     показов
     * @param showConditionAutoPriceParams параметры для автоматического вычисления недостающих ставок в условиях
     *                                     показов. Должен быть не {@code null}, если
     *                                     {@code showConditionAutoPrices == true}
     * @param ucCustomAudienceEnabled      включает обновление ретаргетинга (включено для UpdateAdsJob по фиче)
     */
    public ComplexTextAdGroupUpdateOperation(boolean saveDraft,
                                             UpdateComplexAdGroupValidationService complexValidationService,
                                             AdGroupService adGroupService,
                                             UpdateComplexTextAdGroupValidationService updateValidationService,
                                             KeywordModifyOperationFactory keywordModifyOperationFactory,
                                             RelevanceMatchService relevanceMatchService,
                                             OfferRetargetingService offerRetargetingService,
                                             RetargetingService retargetingService,
                                             BidModifierService bidModifierService,
                                             ComplexBidModifierService complexBidModifierService,
                                             BannersAddOperationFactory bannersAddOperationFactory,
                                             BannersUpdateOperationFactory bannersUpdateOperationFactory,
                                             RetargetingConditionOperationFactory retargetingConditionOperationFactory,
                                             VcardService vcardService,
                                             SitelinkSetService sitelinkSetService,
                                             CampaignRepository campaignRepository,
                                             AdGroupRepository adGroupRepository,
                                             KeywordRepository keywordRepository,
                                             RelevanceMatchRepository relevanceMatchRepository,
                                             OfferRetargetingRepository offerRetargetingRepository,
                                             List<ComplexTextAdGroup> complexAdGroups,
                                             GeoTree geoTree,
                                             boolean showConditionAutoPrices,
                                             boolean ucCustomAudienceEnabled,
                                             @Nullable ShowConditionAutoPriceParams showConditionAutoPriceParams,
                                             long operatorUid, ClientId clientId, long clientUid, int shard) {
        super(Applicability.FULL, saveDraft, adGroupService, complexAdGroups, geoTree, operatorUid, clientId);
        this.updateValidationService = updateValidationService;
        this.clientId = clientId;

        Set<Long> affectedAdGroupIds = adGroupSimpleMap.keySet();

        ShowConditionFixedAutoPrices showConditionFixedAutoPrices = null;
        if (showConditionAutoPrices) {
            checkArgument(showConditionAutoPriceParams != null,
                    "showConditionAutoPriceParams must be specified in showConditionAutoPrices mode");
            showConditionFixedAutoPrices = showConditionAutoPriceParams.getFixedAutoPrices();
        }
        var suppliersList = new ArrayList<UpdateSubEntityLogicSupplier<ComplexTextAdGroup>>();

        bannersLogicSupplier = new ComplexBannerLogicSupplier<>(complexAdGroups, ComplexTextAdGroup.COMPLEX_BANNERS,
                        adGroupSimpleMap, bannersAddOperationFactory, bannersUpdateOperationFactory, vcardService,
                        sitelinkSetService, operatorUid, clientId, bannersModerationMode);

        suppliersList.add(
                new KeywordLogicSupplier<>(complexAdGroups, ComplexTextAdGroup.KEYWORDS,
                        affectedAdGroupIds, keywordModifyOperationFactory, keywordRepository, showConditionAutoPrices,
                        showConditionAutoPriceParams, operatorUid, clientId, clientUid, shard)
        );
        suppliersList.add(
                new OfferRetargetingLogicSupplier<>(complexAdGroups, OFFER_RETARGETINGS, affectedAdGroupIds,
                        operatorUid, clientId, clientUid, shard, offerRetargetingService, offerRetargetingRepository)
        );
        suppliersList.add(
                new RelevanceMatchLogicSupplier<>(complexAdGroups, RELEVANCE_MATCHES, affectedAdGroupIds,
                        relevanceMatchService, relevanceMatchRepository, showConditionAutoPrices,
                        showConditionAutoPriceParams, operatorUid, clientId, clientUid, shard)
        );
        if (ucCustomAudienceEnabled) {
            suppliersList.add(
                    new AddUpdateRetargetingConditionLogicSupplier<>(complexAdGroups,
                            ComplexTextAdGroup.RETARGETING_CONDITION, retargetingConditionOperationFactory, clientId)
            );
        }
        suppliersList.add(
                new RetargetingLogicSupplier<>(complexAdGroups, TARGET_INTERESTS, retargetingService, adGroupSimpleMap,
                        Collections.emptyMap(), showConditionAutoPrices, showConditionFixedAutoPrices, operatorUid,
                        clientId, clientUid, shard)
        );
        suppliersList.add(
                new BidModifierLogicSupplier<>(complexAdGroups, ComplexTextAdGroup.COMPLEX_BID_MODIFIER,
                        affectedAdGroupIds, bidModifierService, complexBidModifierService, campaignRepository,
                        operatorUid, clientId, shard)
        );
        this.suppliers = suppliersList;
    }

    @Override
    protected void afterAdGroupsPrepare(ValidationResult<List<AdGroup>, Defect> adGroupsResult) {
        validateInterconnections(adGroupsResult);

        bannersLogicSupplier.prepare(adGroupsResult);

        for (var supplier : suppliers) {
            supplier.prepare(adGroupsResult);
        }
    }

    private void validateInterconnections(ValidationResult<List<AdGroup>, Defect> adGroupsResult) {
        ValidationResult<List<AdGroup>, Defect> complexAdGroupsResult = updateValidationService
                .validateAdGroups(adGroupsResult, complexAdGroups, clientId);
        checkState(!complexAdGroupsResult.hasErrors() && !complexAdGroupsResult.hasWarnings(),
                "ComplexAdGroupValidationService must not return operational errors or warnings");
    }

    @Override
    protected void afterAdGroupsApply(MassResult<Long> updateAdGroupsResult) {
        bannersLogicSupplier.apply(updateAdGroupsResult);
        // Применение ключевых фраз должно осуществляться только после применения баннеров,
        // так как внутри осуществляется извлечение из базы баннеров для похода в торги.
        // Потенциальная точка рефакторинга.
        for (var supplier : suppliers) {
            supplier.apply(updateAdGroupsResult);
        }
    }
}
