package ru.yandex.direct.core.entity.adgroup.service.complex.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

import javax.annotation.Nullable;

import com.google.common.collect.ImmutableMap;

import ru.yandex.direct.core.entity.adgroup.container.ComplexTextAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.adgroup.repository.AdGroupRepository;
import ru.yandex.direct.core.entity.adgroup.service.AdGroupService;
import ru.yandex.direct.core.entity.adgroup.service.complex.ComplexAdGroupUpdateOperation;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.update.AddUpdateRetargetingConditionLogicSupplier;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.update.BidModifierLogicSupplier;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.update.ComplexBannerLogicSupplier;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.update.KeywordLogicSupplier;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.update.OfferRetargetingLogicSupplier;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.update.RelevanceMatchLogicSupplier;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.update.RetargetingLogicSupplier;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.update.UpdateSubEntityLogicSupplier;
import ru.yandex.direct.core.entity.banner.service.BannersAddOperationFactory;
import ru.yandex.direct.core.entity.banner.service.BannersUpdateOperationFactory;
import ru.yandex.direct.core.entity.bidmodifiers.service.BidModifierService;
import ru.yandex.direct.core.entity.bidmodifiers.service.ComplexBidModifierService;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.core.entity.keyword.repository.KeywordRepository;
import ru.yandex.direct.core.entity.keyword.service.KeywordModifyOperationFactory;
import ru.yandex.direct.core.entity.offerretargeting.repository.OfferRetargetingRepository;
import ru.yandex.direct.core.entity.offerretargeting.service.OfferRetargetingService;
import ru.yandex.direct.core.entity.relevancematch.repository.RelevanceMatchRepository;
import ru.yandex.direct.core.entity.relevancematch.service.RelevanceMatchService;
import ru.yandex.direct.core.entity.retargeting.model.TargetInterest;
import ru.yandex.direct.core.entity.retargeting.service.RetargetingConditionOperationFactory;
import ru.yandex.direct.core.entity.retargeting.service.RetargetingService;
import ru.yandex.direct.core.entity.showcondition.container.ShowConditionAutoPriceParams;
import ru.yandex.direct.core.entity.showcondition.container.ShowConditionFixedAutoPrices;
import ru.yandex.direct.core.entity.sitelink.service.SitelinkSetService;
import ru.yandex.direct.core.entity.vcard.service.VcardService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.operation.Applicability;
import ru.yandex.direct.regions.GeoTree;
import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkState;
import static ru.yandex.direct.core.entity.adgroup.container.ComplexTextAdGroup.OFFER_RETARGETINGS;

public class RestrictedTextAdGroupUpdateOperation extends ComplexAdGroupUpdateOperation<ComplexTextAdGroup> {

    public static boolean isFakeCpmRetCondIdForTextAdGroup(Long id, TargetInterest targetInterest) {
        return id != null && Long.valueOf(-id).equals(targetInterest.getAdGroupId());
    }

    private final UpdateComplexTextAdGroupValidationService updateValidationService;

    private final ComplexBannerLogicSupplier<ComplexTextAdGroup> bannerLogicSupplier;

    private final List<UpdateSubEntityLogicSupplier<? extends ComplexTextAdGroup>> logicSuppliers = new ArrayList<>();
    private final AddUpdateRetargetingConditionLogicSupplier<ComplexTextAdGroup> retargetingConditionLogicSupplier;

    /**
     * Сокращенная комплексная операция
     * Данный класс используется для поэтапного запуска редактирования групп в гриде (DIRECT-88446)
     * Содержит лишь часть функциональности из {@code ComplexTextAdGroupUpdateOperation}.
     * При запуске полноценного редактирования групп, переходим на использование {@code ComplexTextAdGroupUpdateOperation},
     *
     * @param showConditionAutoPrices      включает режим автоматического вычисления недостающих ставок в условиях
     *                                     показов
     * @param showConditionAutoPriceParams параметры для автоматического вычисления недостающих ставок в условиях
     *                                     показов. Должен быть не {@code null}, если
     *                                     {@code showConditionAutoPrices == true}
     */
    public RestrictedTextAdGroupUpdateOperation(boolean saveDraft,
                                                AdGroupService adGroupService,
                                                UpdateComplexTextAdGroupValidationService updateValidationService,
                                                KeywordModifyOperationFactory keywordModifyOperationFactory,
                                                RelevanceMatchService relevanceMatchService,
                                                OfferRetargetingService offerRetargetingService,
                                                RetargetingService retargetingService,
                                                BidModifierService bidModifierService,
                                                ComplexBidModifierService complexBidModifierService,
                                                BannersAddOperationFactory bannersAddOperationFactory,
                                                BannersUpdateOperationFactory bannersUpdateOperationFactory,
                                                VcardService vcardService,
                                                SitelinkSetService sitelinkSetService,
                                                CampaignRepository campaignRepository,
                                                AdGroupRepository adGroupRepository,
                                                KeywordRepository keywordRepository,
                                                RelevanceMatchRepository relevanceMatchRepository,
                                                OfferRetargetingRepository offerRetargetingRepository,
                                                List<ComplexTextAdGroup> complexAdGroups,
                                                GeoTree geoTree,
                                                boolean showConditionAutoPrices,
                                                @Nullable ShowConditionAutoPriceParams showConditionAutoPriceParams,
                                                long operatorUid, ClientId clientId, long clientUid, int shard,
                                                Set<ModelProperty> availableProperties,
                                                RetargetingConditionOperationFactory retargetingConditionOperationFactory) {
        super(Applicability.FULL, saveDraft, adGroupService, complexAdGroups, geoTree, operatorUid, clientId);
        this.updateValidationService = updateValidationService;

        Set<Long> affectedAdGroupIds = adGroupSimpleMap.keySet();

        final ShowConditionFixedAutoPrices showConditionFixedAutoPrices;
        if (showConditionAutoPrices) {
            checkArgument(showConditionAutoPriceParams != null,
                    "showConditionAutoPriceParams must be specified in showConditionAutoPrices mode");
            showConditionFixedAutoPrices = showConditionAutoPriceParams.getFixedAutoPrices();
        } else {
            showConditionFixedAutoPrices = null;
        }

        bannerLogicSupplier = new ComplexBannerLogicSupplier<>(complexAdGroups, ComplexTextAdGroup.COMPLEX_BANNERS,
                adGroupSimpleMap, bannersAddOperationFactory, bannersUpdateOperationFactory, vcardService,
                sitelinkSetService, operatorUid, clientId, bannersModerationMode);

        Supplier<KeywordLogicSupplier<ComplexTextAdGroup>> keywordLogicSupplierInitializer =
                () -> new KeywordLogicSupplier<>(complexAdGroups, ComplexTextAdGroup.KEYWORDS,
                        affectedAdGroupIds, keywordModifyOperationFactory, keywordRepository,
                        showConditionAutoPrices,
                        showConditionAutoPriceParams, operatorUid, clientId, clientUid, shard);

        Supplier<RelevanceMatchLogicSupplier<ComplexTextAdGroup>> relevanceMatchLogicSupplierInitializer =
                () -> new RelevanceMatchLogicSupplier<>(complexAdGroups,
                        ComplexTextAdGroup.RELEVANCE_MATCHES, affectedAdGroupIds, relevanceMatchService,
                        relevanceMatchRepository, showConditionAutoPrices, showConditionAutoPriceParams,
                        operatorUid,
                        clientId, clientUid, shard);

        Supplier<OfferRetargetingLogicSupplier<ComplexTextAdGroup>> offerRetargetingLogicSupplierInitializer =
                () -> new OfferRetargetingLogicSupplier<>(complexAdGroups, OFFER_RETARGETINGS, affectedAdGroupIds,
                        operatorUid, clientId, clientUid, shard, offerRetargetingService, offerRetargetingRepository);

        Supplier<BidModifierLogicSupplier<ComplexTextAdGroup>> bidModifierLogicSupplierInitializer =
                () -> new BidModifierLogicSupplier<>(complexAdGroups, ComplexTextAdGroup.COMPLEX_BID_MODIFIER,
                        affectedAdGroupIds, bidModifierService, complexBidModifierService, campaignRepository,
                        operatorUid, clientId, shard);

        retargetingConditionLogicSupplier = new AddUpdateRetargetingConditionLogicSupplier<>(complexAdGroups, ComplexTextAdGroup.RETARGETING_CONDITION,
                retargetingConditionOperationFactory, clientId);

        Supplier<RetargetingLogicSupplier<ComplexTextAdGroup>> retargetingLogicSupplierInitializer =
                () -> new RetargetingLogicSupplier<>(complexAdGroups, ComplexTextAdGroup.TARGET_INTERESTS,
                        retargetingService, adGroupSimpleMap, Collections.emptyMap(), showConditionAutoPrices,
                        showConditionFixedAutoPrices, operatorUid, clientId, clientUid, shard);

        Map<ModelProperty, Supplier<? extends UpdateSubEntityLogicSupplier<ComplexTextAdGroup>>>
                logicSuppliersInitMap =
                ImmutableMap.<ModelProperty, Supplier<? extends UpdateSubEntityLogicSupplier<ComplexTextAdGroup>>>builder()
                        .put(ComplexTextAdGroup.KEYWORDS, keywordLogicSupplierInitializer)
                        .put(ComplexTextAdGroup.RELEVANCE_MATCHES, relevanceMatchLogicSupplierInitializer)
                        .put(ComplexTextAdGroup.OFFER_RETARGETINGS, offerRetargetingLogicSupplierInitializer)
                        .put(ComplexTextAdGroup.TARGET_INTERESTS, retargetingLogicSupplierInitializer)
                        .put(ComplexTextAdGroup.COMPLEX_BID_MODIFIER, bidModifierLogicSupplierInitializer)
                        .build();

        for (ModelProperty modelProperty : logicSuppliersInitMap.keySet()) {
            if (availableProperties.contains(modelProperty)) {
                logicSuppliers.add(logicSuppliersInitMap.get(modelProperty).get());
            }
        }
    }

    @Override
    protected void afterAdGroupsPrepare(ValidationResult<List<AdGroup>, Defect> adGroupsResult) {
        validateInterconnections(adGroupsResult);
        bannerLogicSupplier.prepare(adGroupsResult);
        retargetingConditionLogicSupplier.prepare(adGroupsResult);

        for (UpdateSubEntityLogicSupplier<? extends ComplexTextAdGroup> supplier : logicSuppliers) {
            supplier.prepare(adGroupsResult);
        }
    }


    private void validateInterconnections(ValidationResult<List<AdGroup>, Defect> adGroupsResult) {
        ValidationResult<List<AdGroup>, Defect> complexAdGroupsResult = updateValidationService
                .validateAdGroups(adGroupsResult, complexAdGroups, clientId);
        checkState(!complexAdGroupsResult.hasErrors() && !complexAdGroupsResult.hasWarnings(),
                "ComplexAdGroupValidationService must not return operational errors or warnings");
    }

    @Override
    protected void afterAdGroupsApply(MassResult<Long> updateAdGroupsResult) {
        bannerLogicSupplier.apply(updateAdGroupsResult);
        retargetingConditionLogicSupplier.apply(updateAdGroupsResult);
        // Применение ключевых фраз должно осуществляться только после применения баннеров,
        // так как внутри осуществляется извлечение из базы баннеров для похода в торги.
        // Потенциальная точка рефакторинга.
        for (UpdateSubEntityLogicSupplier<? extends ComplexTextAdGroup> supplier : logicSuppliers) {
            supplier.apply(updateAdGroupsResult);
        }
    }
}
