package ru.yandex.direct.core.entity.adgroup.service.geotree;

import java.util.Map;

import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.regions.GeoTree;

public class AdGroupGeoTreeProvider {

    private final GeoTree clientGeoTree;
    private final GeoTree priceSalesTree;
    private final Map<Long, CampaignType> campaignTypes;

    AdGroupGeoTreeProvider(
            GeoTree clientGeoTree,
            GeoTree priceSalesTree,
            Map<Long, CampaignType> campaignTypes) {
        this.clientGeoTree = clientGeoTree;
        this.priceSalesTree = priceSalesTree;
        this.campaignTypes = campaignTypes;
    }

    public GeoTree getGeoTree(AdGroup adGroup) {
        return getGeoTree(adGroup.getCampaignId());
    }

    public GeoTree getGeoTree(Long campaignId) {
        var campaignType = campaignTypes.get(campaignId);
        return campaignType == CampaignType.CPM_PRICE ? priceSalesTree : clientGeoTree;
    }
}

