package ru.yandex.direct.core.entity.adgroup.service.geotree;

import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.entity.pricepackage.service.PricePackageService;
import ru.yandex.direct.regions.GeoTree;

@Component
public class AdGroupGeoTreeProviderFactory {

    private final PricePackageService pricePackageService;

    @Autowired
    public AdGroupGeoTreeProviderFactory(PricePackageService pricePackageService) {
        this.pricePackageService = pricePackageService;
    }

    /**
     * Создаёт AdGroupGeoTreeProvider, который отдаёт гео-дерево для группы, с которым должны работать операции.
     *
     * @param defaultGeoTree Гео-дерево, которое должно быть использовано, если нет каких то специальных требований.
     *                       Например прайсовая группа в web всегда должна работать с Российским гео-деревом.
     */
    public AdGroupGeoTreeProvider create(GeoTree defaultGeoTree, Map<Long, CampaignType> campaignTypes) {
        return new AdGroupGeoTreeProvider(defaultGeoTree, pricePackageService.getGeoTree(), campaignTypes);
    }
}
