package ru.yandex.direct.core.entity.adgroup.service.update;

import java.util.List;
import java.util.Objects;

import javax.annotation.Nonnull;

import ru.yandex.direct.core.entity.adgroup.model.AdGroup;

import static java.util.Collections.emptyList;

/**
 * Параметры определяющие набор действий, которые необходимо выполнить после
 * непосредственного обновления таблиц соответсвующих группе объявлений
 */
public final class AdGroupPostUpdateOptions {
    /**
     * Группа объявлений
     */
    private final AdGroup adGroup;
    /**
     * Отправлена ли группа на модерацию
     */
    private boolean adGroupSentToModeration;
    /**
     * Новый геофлаг для баннеров входящих в данную группу объявлений. Если null, то оставляем старый
     */
    private Boolean newBannersGeoFlag;
    /**
     * Обновить sumGeo у непромодерированных креативов.
     */
    private Boolean updateCreativesSumGeo;
    /**
     * Нужно ли переотправлять в БК баннеры данной группы?
     */
    private boolean resetBannersStatusBsSync;
    /**
     * Нужно ли сбрасывать признак отмодерированности для баннеры данной группы?
     */
    private boolean clearBannersModerationFlags;
    /**
     * Список идентификаторов баннеров, которых нужно отправить на перемодерацию
     */
    private List<Long> remoderateBannerIds = emptyList();
    /**
     * Список идентификаторов баннеров, для которых нужно отправить на перемодерацию мультибанеры
     */
    private List<Long> remoderateMulticardSetBannerIds = emptyList();
    /**
     * Нужно запускать перерасчет прогноза показов?
     */
    private boolean scheduleForecastRecalc;

    AdGroupPostUpdateOptions(@Nonnull AdGroup adGroup) {
        this.adGroup = Objects.requireNonNull(adGroup, "adGroup");
    }


    public AdGroup getAdGroup() {
        return adGroup;
    }

    public boolean isAdGroupSentToModeration() {
        return adGroupSentToModeration;
    }

    public void setAdGroupSentToModeration(boolean adGroupSentToModeration) {
        this.adGroupSentToModeration = adGroupSentToModeration;
    }

    public Boolean getNewBannersGeoFlag() {
        return newBannersGeoFlag;
    }

    public void setNewBannersGeoFlag(Boolean newBannersGeoFlag) {
        this.newBannersGeoFlag = newBannersGeoFlag;
    }

    public Boolean isUpdateCreativesSumGeo() {
        return updateCreativesSumGeo;
    }

    public void setUpdateCreativesSumGeo(Boolean updateCreativesSumGeo) {
        this.updateCreativesSumGeo = updateCreativesSumGeo;
    }

    public boolean isResetBannersStatusBsSync() {
        return resetBannersStatusBsSync;
    }

    public void setResetBannersStatusBsSync(boolean resetBannersStatusBsSync) {
        this.resetBannersStatusBsSync = resetBannersStatusBsSync;
    }

    public boolean isClearBannersModerationFlags() {
        return clearBannersModerationFlags;
    }

    public void setClearBannersModerationFlags(boolean clearBannersModerationFlags) {
        this.clearBannersModerationFlags = clearBannersModerationFlags;
    }

    public List<Long> getRemoderateBannerIds() {
        return remoderateBannerIds;
    }

    public void setRemoderateBannerIds(List<Long> remoderateBannerIds) {
        this.remoderateBannerIds = remoderateBannerIds;
    }

    public List<Long> getRemoderateMulticardSetBannerIds() {
        return remoderateMulticardSetBannerIds;
    }

    public void setRemoderateMulticardSetBannerIds(List<Long> remoderateMulticardSetBannerIds) {
        this.remoderateMulticardSetBannerIds = remoderateMulticardSetBannerIds;
    }

    public boolean isScheduleForecastRecalc() {
        return scheduleForecastRecalc;
    }

    public void setScheduleForecastRecalc(boolean scheduleForecastRecalc) {
        this.scheduleForecastRecalc = scheduleForecastRecalc;
    }
}
