package ru.yandex.direct.core.entity.adgroup.service.update;

import java.util.List;

import com.google.common.collect.ImmutableList;

import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields;
import ru.yandex.direct.core.entity.campaign.model.CampaignSimple;
import ru.yandex.direct.model.AppliedChanges;

import static java.util.Collections.emptyList;

public class AdGroupUpdateData {
    private final AppliedChanges<AdGroup> adGroupChanges;
    private final CampaignSimple campaign;
    private final List<BannerWithSystemFields> banners;

    public AdGroupUpdateData(
            AppliedChanges<AdGroup> adGroupChanges, CampaignSimple campaign,
            List<BannerWithSystemFields> banners) {
        this.adGroupChanges = adGroupChanges;
        this.campaign = campaign;
        this.banners = banners != null ? ImmutableList.copyOf(banners) : emptyList();
    }

    public AppliedChanges<AdGroup> getAdGroupChanges() {
        return adGroupChanges;
    }

    public CampaignSimple getCampaign() {
        return campaign;
    }

    public List<BannerWithSystemFields> getBanners() {
        return banners;
    }
}
