package ru.yandex.direct.core.entity.adgroup.service.update;

import java.util.List;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.adgroup.service.ModerationMode;
import ru.yandex.direct.dbutil.model.ClientId;

/**
 * Реализации данного интерфейса инкапсулируют бизнес-логику выполняемую при сохранении
 * групп объявлений разных типов.
 * <p>
 * Например, отвечая на вопрос в каких случая обновлять поле LAST_CHANGE. В какой-то степени,
 * реализации данного интерфейса воспроизводят иерархию protected/Direct/Model/AdGroup/Manager.pm
 */
public interface AdGroupUpdateService {
    /**
     * Поддерживаемый тип группы объявлений
     */
    AdGroupType getSupportedType();

    /**
     * Выполнить обновление набора групп объявлений для заданного типа групп объявлений
     */
    void update(int shard, ClientId clientId, ModerationMode moderationMode,
                List<AdGroupUpdateData> adGroupsUpdateData);
}
