package ru.yandex.direct.core.entity.adgroup.service.update.types;

import java.time.LocalDateTime;

import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.StatusBsSynced;
import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.adgroup.model.CpmIndoorAdGroup;
import ru.yandex.direct.core.entity.adgroup.repository.AdGroupRepository;
import ru.yandex.direct.core.entity.adgroup.service.ModerationMode;
import ru.yandex.direct.core.entity.adgroup.service.update.AbstractAdGroupUpdateService;
import ru.yandex.direct.core.entity.adgroup.service.update.AdGroupPostUpdateOptions;
import ru.yandex.direct.core.entity.adgroup.service.update.AdGroupUpdateData;
import ru.yandex.direct.core.entity.banner.repository.BannerCommonRepository;
import ru.yandex.direct.core.entity.banner.repository.BannerModerationRepository;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.core.entity.creative.service.CreativeService;
import ru.yandex.direct.core.entity.moderation.repository.sending.BannerMulticardSetSendingRepository;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.regions.GeoTreeFactory;

@Service
public class CmpIndoorUpdateService extends AbstractAdGroupUpdateService {
    protected CmpIndoorUpdateService(
            DslContextProvider dslContextProvider,
            BannerCommonRepository bannerCommonRepository,
            BannerModerationRepository bannerModerationRepository,
            BannerMulticardSetSendingRepository bannerMulticardSetSendingRepository,
            CampaignRepository campaignRepository,
            AdGroupRepository adGroupRepository,
            CreativeService creativeService,
            GeoTreeFactory geoTreeFactory) {
        super(
                AdGroupType.CPM_INDOOR,
                dslContextProvider,
                bannerCommonRepository,
                bannerModerationRepository,
                bannerMulticardSetSendingRepository,
                campaignRepository,
                adGroupRepository,
                creativeService,
                geoTreeFactory);
    }

    /**
     * Отправляем indoor группу в БК, если изменился список пейджей.
     */
    @Override
    protected AdGroupPostUpdateOptions doPrepareForUpdate(AdGroupUpdateData adGroupsUpdateData,
                                                          ModerationMode moderationMode) {
        AdGroupPostUpdateOptions result = super.doPrepareForUpdate(adGroupsUpdateData, moderationMode);

        AppliedChanges<CpmIndoorAdGroup> adGroupChanges = adGroupsUpdateData.getAdGroupChanges()
                .castModelUp(CpmIndoorAdGroup.class);

        if (adGroupChanges.changed(CpmIndoorAdGroup.PAGE_BLOCKS)) {
            adGroupChanges.modify(AdGroup.STATUS_BS_SYNCED, StatusBsSynced.NO);
            adGroupChanges.modifyIfNotChanged(AdGroup.LAST_CHANGE, LocalDateTime::now);
        }

        return result;
    }
}
