package ru.yandex.direct.core.entity.adgroup.service.update.types;

import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.adgroup.repository.AdGroupRepository;
import ru.yandex.direct.core.entity.adgroup.service.ModerationMode;
import ru.yandex.direct.core.entity.adgroup.service.update.AbstractAdGroupUpdateService;
import ru.yandex.direct.core.entity.adgroup.service.update.AdGroupPostUpdateOptions;
import ru.yandex.direct.core.entity.adgroup.service.update.AdGroupUpdateData;
import ru.yandex.direct.core.entity.banner.repository.BannerCommonRepository;
import ru.yandex.direct.core.entity.banner.repository.BannerModerationRepository;
import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.core.entity.creative.service.CreativeService;
import ru.yandex.direct.core.entity.moderation.repository.sending.BannerMulticardSetSendingRepository;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.regions.GeoTreeFactory;

import static com.google.common.base.Preconditions.checkArgument;
import static ru.yandex.direct.core.entity.adgroup.service.ModerationMode.FORCE_SAVE_DRAFT;

@Service
public class CpmYndxFrontpageUpdateService extends AbstractAdGroupUpdateService {
    protected CpmYndxFrontpageUpdateService(
            DslContextProvider dslContextProvider,
            BannerCommonRepository bannerCommonRepository,
            BannerModerationRepository bannerModerationRepository,
            BannerMulticardSetSendingRepository bannerMulticardSetSendingRepository,
            CampaignRepository campaignRepository,
            AdGroupRepository adGroupRepository,
            CreativeService creativeService,
            GeoTreeFactory geoTreeFactory) {
        super(
                AdGroupType.CPM_YNDX_FRONTPAGE,
                dslContextProvider,
                bannerCommonRepository,
                bannerModerationRepository,
                bannerMulticardSetSendingRepository,
                campaignRepository,
                adGroupRepository,
                creativeService,
                geoTreeFactory);
    }

    @Override
    protected AdGroupPostUpdateOptions doPrepareForUpdate(AdGroupUpdateData adGroupUpdateData,
                                                          ModerationMode moderationMode) {
        if (adGroupUpdateData.getCampaign().getType() == CampaignType.CPM_PRICE) {
            checkArgument(moderationMode != FORCE_SAVE_DRAFT,
                    "ModerationMode.FORCE_SAVE_DRAFT forbidden for adGroups in CPM_PRICE campaign");
        }
        return super.doPrepareForUpdate(adGroupUpdateData, moderationMode);
    }
}
