package ru.yandex.direct.core.entity.adgroup.service.update.types;

import java.time.LocalDateTime;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.StatusBsSynced;
import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.adgroup.model.InternalAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.StatusModerate;
import ru.yandex.direct.core.entity.adgroup.model.StatusPostModerate;
import ru.yandex.direct.core.entity.adgroup.repository.AdGroupRepository;
import ru.yandex.direct.core.entity.adgroup.service.ModerationMode;
import ru.yandex.direct.core.entity.adgroup.service.update.AbstractAdGroupUpdateService;
import ru.yandex.direct.core.entity.adgroup.service.update.AdGroupPostUpdateOptions;
import ru.yandex.direct.core.entity.adgroup.service.update.AdGroupUpdateData;
import ru.yandex.direct.core.entity.banner.repository.BannerCommonRepository;
import ru.yandex.direct.core.entity.banner.repository.BannerModerationRepository;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.core.entity.creative.service.CreativeService;
import ru.yandex.direct.core.entity.moderation.repository.sending.BannerMulticardSetSendingRepository;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.regions.GeoTreeFactory;

@Service
@ParametersAreNonnullByDefault
public class InternalUpdateService extends AbstractAdGroupUpdateService {
    protected InternalUpdateService(
            DslContextProvider dslContextProvider,
            BannerCommonRepository bannerCommonRepository,
            BannerModerationRepository bannerModerationRepository,
            BannerMulticardSetSendingRepository bannerMulticardSetSendingRepository,
            CampaignRepository campaignRepository,
            AdGroupRepository adGroupRepository,
            CreativeService creativeService,
            GeoTreeFactory geoTreeFactory) {
        super(
                AdGroupType.INTERNAL,
                dslContextProvider,
                bannerCommonRepository,
                bannerModerationRepository,
                bannerMulticardSetSendingRepository,
                campaignRepository,
                adGroupRepository,
                creativeService,
                geoTreeFactory);
    }

    @Override
    protected AdGroupPostUpdateOptions doPrepareForUpdate(AdGroupUpdateData adGroupsUpdateData,
                                                          ModerationMode moderationMode) {
        AdGroupPostUpdateOptions result = super.doPrepareForUpdate(adGroupsUpdateData, moderationMode);

        AppliedChanges<InternalAdGroup> adGroupChanges = adGroupsUpdateData.getAdGroupChanges()
                .castModelUp(InternalAdGroup.class);

        if (adGroupChanges.changed(InternalAdGroup.LEVEL)
                || adGroupChanges.changed(InternalAdGroup.RF)
                || adGroupChanges.changed(InternalAdGroup.RF_RESET)
                || adGroupChanges.changed(InternalAdGroup.MAX_CLICKS_COUNT)
                || adGroupChanges.changed(InternalAdGroup.MAX_CLICKS_PERIOD)
                || adGroupChanges.changed(InternalAdGroup.MAX_STOPS_COUNT)
                || adGroupChanges.changed(InternalAdGroup.MAX_STOPS_PERIOD)
                || adGroupChanges.changed(InternalAdGroup.START_TIME)
                || adGroupChanges.changed(InternalAdGroup.FINISH_TIME)) {
            adGroupChanges.modify(AdGroup.STATUS_BS_SYNCED, StatusBsSynced.NO);
        }

        adGroupChanges.modify(AdGroup.STATUS_MODERATE, StatusModerate.YES);
        adGroupChanges.modify(AdGroup.STATUS_POST_MODERATE, StatusPostModerate.YES);

        if (adGroupChanges.hasActuallyChangedProps()) {
            adGroupChanges.modifyIfNotChanged(AdGroup.LAST_CHANGE, LocalDateTime::now);
        }

        return result;
    }
}
