package ru.yandex.direct.core.entity.adgroup.service.update.types;

import java.time.LocalDateTime;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.StatusBsSynced;
import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.adgroup.model.MobileContentAdGroup;
import ru.yandex.direct.core.entity.adgroup.repository.AdGroupRepository;
import ru.yandex.direct.core.entity.adgroup.service.ModerationMode;
import ru.yandex.direct.core.entity.adgroup.service.update.AbstractAdGroupUpdateService;
import ru.yandex.direct.core.entity.adgroup.service.update.AdGroupPostUpdateOptions;
import ru.yandex.direct.core.entity.adgroup.service.update.AdGroupUpdateData;
import ru.yandex.direct.core.entity.banner.repository.BannerCommonRepository;
import ru.yandex.direct.core.entity.banner.repository.BannerModerationRepository;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.core.entity.creative.service.CreativeService;
import ru.yandex.direct.core.entity.moderation.repository.sending.BannerMulticardSetSendingRepository;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.regions.GeoTreeFactory;

@ParametersAreNonnullByDefault
@Service
public class MobileContentUpdateService extends AbstractAdGroupUpdateService {
    @Autowired
    public MobileContentUpdateService(
            DslContextProvider dslContextProvider,
            BannerCommonRepository bannerCommonRepository,
            BannerModerationRepository bannerModerationRepository,
            BannerMulticardSetSendingRepository bannerMulticardSetSendingRepository,
            CampaignRepository campaignRepository,
            AdGroupRepository adGroupRepository,
            CreativeService creativeService,
            GeoTreeFactory geoTreeFactory) {
        super(
                AdGroupType.MOBILE_CONTENT,
                dslContextProvider,
                bannerCommonRepository,
                bannerModerationRepository,
                bannerMulticardSetSendingRepository,
                campaignRepository,
                adGroupRepository,
                creativeService,
                geoTreeFactory);
    }

    /**
     * См. protected/Direct/AdGroups2/MobileContent.pm::prepare_update
     */
    @Override
    protected AdGroupPostUpdateOptions doPrepareForUpdate(AdGroupUpdateData adGroupsUpdateData,
                                                          ModerationMode moderationMode) {
        AdGroupPostUpdateOptions result = super.doPrepareForUpdate(adGroupsUpdateData, moderationMode);

        AppliedChanges<AdGroup> adGroupChanges = adGroupsUpdateData.getAdGroupChanges();

        AppliedChanges<MobileContentAdGroup> mobileContentChanges =
                adGroupChanges.castModelUp(MobileContentAdGroup.class);

        if (mobileContentChanges.changed(MobileContentAdGroup.MINIMAL_OPERATING_SYSTEM_VERSION)
                || mobileContentChanges.changed(MobileContentAdGroup.DEVICE_TYPE_TARGETING)
                || mobileContentChanges.changed(MobileContentAdGroup.NETWORK_TARGETING)) {
            adGroupChanges.modify(AdGroup.STATUS_BS_SYNCED, StatusBsSynced.NO);
            adGroupChanges.modifyIfNotChanged(AdGroup.LAST_CHANGE, LocalDateTime::now);
        }

        return result;
    }
}
