package ru.yandex.direct.core.entity.adgroup.service.update.types;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.StatusBsSynced;
import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.adgroup.model.StatusBLGenerated;
import ru.yandex.direct.core.entity.adgroup.model.TextAdGroup;
import ru.yandex.direct.core.entity.adgroup.repository.AdGroupRepository;
import ru.yandex.direct.core.entity.adgroup.service.ModerationMode;
import ru.yandex.direct.core.entity.adgroup.service.update.AbstractAdGroupUpdateService;
import ru.yandex.direct.core.entity.adgroup.service.update.AdGroupPostUpdateOptions;
import ru.yandex.direct.core.entity.adgroup.service.update.AdGroupUpdateData;
import ru.yandex.direct.core.entity.banner.repository.BannerCommonRepository;
import ru.yandex.direct.core.entity.banner.repository.BannerModerationRepository;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.core.entity.creative.service.CreativeService;
import ru.yandex.direct.core.entity.moderation.repository.sending.BannerMulticardSetSendingRepository;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.regions.GeoTreeFactory;

@ParametersAreNonnullByDefault
@Service
public class TextUpdateService extends AbstractAdGroupUpdateService {

    protected TextUpdateService(
            DslContextProvider dslContextProvider,
            BannerCommonRepository bannerCommonRepository,
            BannerModerationRepository bannerModerationRepository,
            BannerMulticardSetSendingRepository bannerMulticardSetSendingRepository,
            CampaignRepository campaignRepository,
            AdGroupRepository adGroupRepository,
            CreativeService creativeService,
            GeoTreeFactory geoTreeFactory) {
        super(
                AdGroupType.BASE,
                dslContextProvider,
                bannerCommonRepository,
                bannerModerationRepository,
                bannerMulticardSetSendingRepository,
                campaignRepository,
                adGroupRepository,
                creativeService,
                geoTreeFactory);
    }

    @Override
    protected AdGroupPostUpdateOptions doPrepareForUpdate(AdGroupUpdateData adGroupUpdateData,
                                                          ModerationMode moderationMode) {
        AdGroupPostUpdateOptions result = super.doPrepareForUpdate(adGroupUpdateData, moderationMode);

        AppliedChanges<AdGroup> adGroupChanges = adGroupUpdateData.getAdGroupChanges();

        // Поведение, похожее на https://a.yandex-team.ru/arc_vcs/direct/core/src/main/java/ru/yandex/direct/core/entity/adgroup/service/update/types/PerformanceUpdateService.java?rev=r8688301#L56
        // Но здесь может меняться и сам фид!
        AppliedChanges<TextAdGroup> changes = adGroupChanges.castModelUp(TextAdGroup.class);

        if (changes.changed(TextAdGroup.FEED_ID) ||
                changes.changed(TextAdGroup.FIELD_TO_USE_AS_NAME) ||
                changes.changed(TextAdGroup.FIELD_TO_USE_AS_BODY)) {

            changes.modify(TextAdGroup.STATUS_B_L_GENERATED, changes.getNewValue(TextAdGroup.FEED_ID) != null ?
                    StatusBLGenerated.PROCESSING : StatusBLGenerated.NO);

            changes.modify(TextAdGroup.STATUS_BS_SYNCED, StatusBsSynced.NO);

            // fieldToUseAs{Name,Body} отправляются в БК отдельно на каждом баннере,
            // поэтому при их изменении нужно сбросить статусы
            result.setResetBannersStatusBsSync(true);
        }

        return result;
    }
}
