package ru.yandex.direct.core.entity.adgroup.service.validation;

import ru.yandex.direct.core.validation.defects.params.CollectionValuesDefectParams;
import ru.yandex.direct.core.validation.defects.params.GeoDefectParams;
import ru.yandex.direct.core.validation.defects.params.ModelIdDefectParams;
import ru.yandex.direct.core.validation.defects.params.PriceSalesTargetingAmountDefectParams;
import ru.yandex.direct.validation.defect.params.NumberDefectParams;
import ru.yandex.direct.validation.defect.params.StringDefectParams;
import ru.yandex.direct.validation.result.DefectId;

public class AdGroupDefectIds {

    public enum AppStoreDomain implements DefectId<AppStoreDomainDefectParams> {
        APP_STORE_IS_NOT_SUPPORTED
    }

    public enum Gen implements DefectId<Void> {
        UNSUPPORTED_GROUP_TYPE,
        MUST_BE_MUTUALLY_EXCLUSIVE,
        ARCHIVED_AD_GROUP_MODIFICATION,
        AD_GROUP_DOES_NOT_CONTAIN_THIS_BANNER,
        AD_GROUP_DOES_NOT_CONTAIN_THIS_KEYWORD,
        AD_GROUP_DOES_NOT_CONTAIN_THIS_RELEVANCE_MATCH,
        INCONSISTENT_AD_GROUP_TYPE_TO_CAMPAIGN_TYPE,
        AD_GROUP_NAME_IS_NOT_SET,
        AD_GROUP_NAME_CANT_BE_EMPTY,
        ADVERTISED_APP_LINK_IS_NOT_SET,
        INVALID_APP_LINK_FORMAT,
        INVALID_APP_STORE_URL,
        MIN_OS_VERSION_IS_NOT_SET,
        INVALID_MIN_OS_VERSION,
        DYNAMIC_TEXT_DOMAIN_IS_NOT_SET,
        INVALID_DYNAMIC_TEXT_DOMAIN,
        DEVICE_TARGETING_IS_NOT_SET,
        NETWORK_TARGETING_IS_NOT_SET,
        NOT_FOUND,
        UNABLE_TO_DELETE,
        MUST_NOT_CONTAIN_DUPLICATED_OBJECTS,
        AD_GROUP_TYPE_NOT_SUPPORTED,
        INCONSISTENT_AD_GROUP_TYPE,
        INCONSISTENT_DYNAMIC_AD_GROUP_TYPE,
        EITHER_KEYWORDS_OR_RETARGETINGS_ALLOWED,
        EMPTY_CONTENT_CATEGORIES_NOT_ALLOWED,
        CONTENT_PROMOTION_SEVERAL_TYPES_NOT_ALLOWED,
        CONTENT_PROMOTION_DISTINCT_TYPE_FROM_EXISTING,
        CONTENT_PROMOTION_ADGROUP_TYPE_CHANGED,
        KEYWORDS_NOT_ALLOWED,
        BID_MODIFIERS_NOT_ALLOWED,
        MINUS_KEYWORDS_NOT_ALLOWED,
        NOT_ALLOWED_VALUE,
        FINISH_TIME_SHOULD_BE_GREATER_THAN_START_TIME,
        ERRORS_WHILE_COPYING_ADGROUPS,
        AD_GROUP_STATUS_ARCHIVED,
        AD_GROUP_STATUS_STOPPED,

        /**
         * Показы запрещены в некоторых регионах
         */
        RESTRICTED_REGIONS,

        STORE_URL_MUST_BE_SAME_FOR_ALL_GROUPS_IN_MOBILE_CONTENT_CAMPAIGN,
        STORE_URL_MUST_BE_SAME_AS_URL_IN_MOBILE_CONTENT_CAMPAIGN,

        /**
         * Прайсовые продажи
         */
        ONLY_ONE_DEFAULT_AD_GROUP_ALLOWED,
        PRICE_SALES_DISALLOWED_ADGROUP_TYPE,
        PRICE_SALES_DISALLOWED_METRIKA_SEGMENTS,
        PRICE_SALES_DISALLOWED_AUDIENCE_SEGMENTS,
        PRICE_SALES_AD_GROUP_TYPE_NOT_ALLOWED,
        PRICE_SALES_INVALID_PRIORITY,
        PRICE_SALES_AD_GROUP_USE_NOT_ALLOWED_BID_MODIFIERS,
        PRICE_SALES_AD_GROUP_NOT_ALLOWED_MOBILE_PLATFORMS_COMBINATION,

        BS_TAG_NOT_ALLOWED,
    }

    public enum Geo implements DefectId<GeoDefectParams> {
        BAD_GEO
    }

    public enum ModelId implements DefectId<ModelIdDefectParams> {
        FEED_NOT_EXIST,
    }

    public enum Number implements DefectId<NumberDefectParams> {
        MAX_ADGROUPS_IN_CAMPAIGN,
        TOO_MANY_BANNERS_IN_AD_GROUP,
    }

    public enum String implements DefectId<StringDefectParams> {
        AD_GROUP_NAME_TOO_LONG
    }

    public enum PriceSalesTargetingAmount implements DefectId<PriceSalesTargetingAmountDefectParams> {
        TOO_MANY_TARGETINGS,
        TOO_FEW_TARGETINGS,
    }

    public enum Banners implements DefectId<CollectionValuesDefectParams<Long>> {
        REQUIRED_AGE_VARIABLE
    }
}
