package ru.yandex.direct.core.entity.adgroup.service.validation;

import ru.yandex.direct.i18n.I18NBundle;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.bundle.MessageFormatStub;
import ru.yandex.direct.i18n.bundle.TranslationBundle;
import ru.yandex.direct.i18n.bundle.TranslationStub;
import ru.yandex.direct.i18n.types.Identity;

@SuppressWarnings("squid:S1214")
public interface AdGroupDefectTranslations extends TranslationBundle {

    AdGroupDefectTranslations INSTANCE = I18NBundle.implement(AdGroupDefectTranslations.class);

    @MessageFormatStub("Попытка выполнить операцию над группой объявлений в архивной кампании.")
    Translatable cantEditArchivedAdGroup();

    @MessageFormatStub("Достигнуто максимальное количество групп объявлений в кампании - {0}")
    Translatable campaignAdGroupsLimitReached(Identity max);

    @TranslationStub("Регион показа не соответствует тексту объявления (заголовки, текст, быстрые ссылки)")
    Translatable invalidGeoTargeting();

    @MessageFormatStub("Геотаргетинг не может быть изменён, так как текст объявления \"{0}\" на украинском языке. Возможен таргетинг только на Украину.")
    Translatable badGeoDetailedInconsistentGeoWithUkrainianLanguage(Identity bannerId);

    @MessageFormatStub("Геотаргетинг не может быть изменён, так как текст объявления \"{0}\" на казахском языке. Возможен таргетинг только на Казахстан.")
    Translatable badGeoDetailedInconsistentGeoWithKazakhLanguage(Identity bannerId);

    @MessageFormatStub("Геотаргетинг не может быть изменён, так как текст объявления \"{0}\" на турецком языке. Возможен таргетинг только на Турцию.")
    Translatable badGeoDetailedInconsistentGeoWithTurkishLanguage(Identity bannerId);

    @MessageFormatStub("Геотаргетинг не может быть изменён, так как текст объявления \"{0}\" на белорусском языке. Возможен таргетинг только на Беларусь.")
    Translatable badGeoDetailedInconsistentGeoWithBelarussianLanguage(Identity bannerId);

    @MessageFormatStub("Геотаргетинг не может быть изменён, так как текст объявления \"{0}\" на узбекском языке. Возможен таргетинг только на Узбекистан.")
    Translatable badGeoDetailedInconsistentGeoWithUzbekLanguage(Identity bannerId);

    @MessageFormatStub("Геотаргетинг не может быть изменён, так как текст объявления \"{0}\" на вьетнамском языке. Возможен таргетинг только на Азию.")
    Translatable badGeoDetailedInconsistentGeoWithVieLanguage(Identity bannerId);

    @MessageFormatStub("Тип группы не соответствует типу кампании")
    Translatable inconsistentAdGroupTypeToCampaignType();

    @MessageFormatStub("Тип группы объявлений не соответствует кампании")
    Translatable inconsistentAdGroupTypeToCampaign();

    @MessageFormatStub("Необходимо задать название группы")
    Translatable adGroupNameIsNotSet();

    @MessageFormatStub("Имя группы не может быть пустой строкой \"\"")
    Translatable adGroupNameCantBeEmpty();

    @MessageFormatStub("Значение в поле Name не должно превышать {0} символов")
    Translatable adGroupNameTooLong(Identity max);

    @MessageFormatStub("Необходимо задать ссылку рекламируемого приложения")
    Translatable advertisedAppLinkIsNotSetDetailed();

    @MessageFormatStub("Фид с id={0} не найден")
    Translatable feedNotExistDetailed(Identity feedId);

    @MessageFormatStub("Неправильный формат ссылки")
    Translatable invalidAppLinkFormatDetailed();

    @MessageFormatStub("Магазин приложений не поддерживается (разрешены только {0})")
    Translatable unsupportedAppStoreDetailed(String supportedAppStores);

    @MessageFormatStub("Не удалось получить информацию о приложении")
    Translatable invalidAppStoreUrlDetailed();

    @MessageFormatStub("Необходимо задать минимальную версию ОС")
    Translatable minOsVersionIsNotSetDetailed();

    @MessageFormatStub("Версия ОС задана некорректно")
    Translatable invalidMinOsVersionDetailed();

    @MessageFormatStub("Необходимо задать устройства для таргетинга")
    Translatable deviceTargetingIsNotSetDetailed();

    @MessageFormatStub("Необходимо задать тип связи для таргетинга")
    Translatable networkTargetingIsNotSetDetailed();

    @MessageFormatStub("Необходимо задать основной домен группы объявлений")
    Translatable dynamicTextDomainIsNotSet();

    @MessageFormatStub("Указан некорректный основной домен группы объявлений")
    Translatable invalidDynamicTextDomainDetailed();

    @MessageFormatStub("Разрешено создавать не более {0} групп объявлений в одном запросе")
    Translatable maxAdGroupsPerRequestDetailed(Identity max);

    @MessageFormatStub("Разрешено изменять не более {0} групп объявлений в одном запросе")
    Translatable maxAdGroupsPerUpdateRequestDetailed(Identity max);

    @MessageFormatStub("Группа объявлений не найдена")
    Translatable notFoundDetailed();

    @MessageFormatStub("Нельзя удалить группу, содержащую объявления или условия показа")
    Translatable unableToDeleteDetailed();

    @TranslationStub("Тип группы объявлений не совпадает с указанным в запросе")
    Translatable inconsistentAdGroupType();

    @TranslationStub("Подтип группы объявлений не совпадает с указанным в запросе")
    Translatable inconsistentDynamicAdGroupSubType();

    @TranslationStub("Показы запрещены в некоторых регионах")
    Translatable restrictedRegionsShort();

    @TranslationStub("Объявления в этой группе не будут показаны в некоторых регионах в соответствии с местным законодательством")
    Translatable restrictedRegionsDetails();

    @TranslationStub("Запрещено создавать группы партнёрского контента с разным типом контента")
    Translatable contentPromotionSeveralTypesNotAllowed();

    @TranslationStub("Запрещено создавать группы партнёрского контента с иным типом контента, чем существующий")
    Translatable contentPromotionDistinctTypeFromExisting();

    @TranslationStub("Нельзя менять тип партнёрского контента на существующей группе")
    Translatable contentPromotionAdGroupTypeChanged();

    @TranslationStub("В кампании для рекламы мобильных приложений во всех группах объявлений должна быть ссылка на одно и тоже приложение. Для рекламы нескольких приложений создайте отдельные кампании")
    Translatable storeUrlMustBeTheSameForAllGroupsInMobileContentCampaign();

    @TranslationStub("Ссылка на приложение в группе объявлений не совпадает со ссылкой в кампании")
    Translatable storeUrlMustBeTheSameAsUrlInMobileContentCampaign();

    @TranslationStub("Минус-фразы недоступны в данной группе объявлений")
    Translatable minusKeywordsAreNotAllowed();

    @TranslationStub("Товарные дополнения на поиске больше не поддерживаются. Фиды не будут добавлены к группе объявлений.")
    Translatable feedsNotAllowed();

    @TranslationStub("Обратите внимание, регион показа изменился с «Точного местоположения» на «Страны, области города»")
    Translatable hyperGeoSettingsWasFlushed();

    @TranslationStub("Логотип можно указывать только для смарт-баннеров без креативов")
    Translatable logoIsOnlyForBannersWithoutCreative();
}
