package ru.yandex.direct.core.entity.adgroup.service.validation;

import java.util.List;
import java.util.Set;

import ru.yandex.direct.core.entity.pricepackage.model.PricePackageRetargetingSubCategory;
import ru.yandex.direct.core.validation.defects.params.CollectionValuesDefectParams;
import ru.yandex.direct.core.validation.defects.params.GeoDefectParams;
import ru.yandex.direct.core.validation.defects.params.ModelIdDefectParams;
import ru.yandex.direct.core.validation.defects.params.PriceSalesTargetingAmountDefectParams;
import ru.yandex.direct.queryrec.model.Language;
import ru.yandex.direct.validation.defect.params.NumberDefectParams;
import ru.yandex.direct.validation.defect.params.StringDefectParams;
import ru.yandex.direct.validation.result.Defect;

public class AdGroupDefects {
    private AdGroupDefects() {
    }

    public static Defect<Void> unsupportedAdGroupType() {
        return new Defect<>(AdGroupDefectIds.Gen.UNSUPPORTED_GROUP_TYPE);
    }

    public static Defect<Void> mutuallyExclusive() {
        return new Defect<>(AdGroupDefectIds.Gen.MUST_BE_MUTUALLY_EXCLUSIVE);
    }

    public static Defect archivedAdGroupModification() {
        return new Defect<>(AdGroupDefectIds.Gen.ARCHIVED_AD_GROUP_MODIFICATION);
    }

    public static Defect inconsistentGeoWithBannerLanguages(Language language, Long bannerId) {
        return new Defect<>(AdGroupDefectIds.Geo.BAD_GEO,
                new GeoDefectParams().withLanguage(language).withBannerId(bannerId));
    }

    public static Defect maxAdGroupsInCampaign(long max) {
        return new Defect<>(AdGroupDefectIds.Number.MAX_ADGROUPS_IN_CAMPAIGN,
                new NumberDefectParams().withMax(max));
    }

    public static Defect<Void> adGroupDoesNotContainThisBanner() {
        return new Defect<>(AdGroupDefectIds.Gen.AD_GROUP_DOES_NOT_CONTAIN_THIS_BANNER);
    }

    public static Defect<Void> adGroupDoesNotContainThisKeyword() {
        return new Defect<>(AdGroupDefectIds.Gen.AD_GROUP_DOES_NOT_CONTAIN_THIS_KEYWORD);
    }

    public static Defect<Void> adGroupDoesNotContainThisRelevanceMatch() {
        return new Defect<>(AdGroupDefectIds.Gen.AD_GROUP_DOES_NOT_CONTAIN_THIS_RELEVANCE_MATCH);
    }

    public static Defect<Void> inconsistentAdGroupTypeToCampaignType() {
        return new Defect<>(AdGroupDefectIds.Gen.INCONSISTENT_AD_GROUP_TYPE_TO_CAMPAIGN_TYPE);
    }

    public static Defect<Void> adGroupNameIsNotSet() {
        return new Defect<>(AdGroupDefectIds.Gen.AD_GROUP_NAME_IS_NOT_SET);
    }

    public static Defect<Void> adGroupNameCantBeEmpty() {
        return new Defect<>(AdGroupDefectIds.Gen.AD_GROUP_NAME_CANT_BE_EMPTY);
    }

    public static Defect<StringDefectParams> adGroupNameTooLong(int maxLength) {
        return new Defect<>(
                AdGroupDefectIds.String.AD_GROUP_NAME_TOO_LONG,
                new StringDefectParams().withMaxLength(maxLength));
    }

    public static Defect<Void> advertisedAppLinkIsNotSet() {
        return new Defect<>(AdGroupDefectIds.Gen.ADVERTISED_APP_LINK_IS_NOT_SET);
    }

    public static Defect feedNotExist(Long id) {
        return new Defect<>(AdGroupDefectIds.ModelId.FEED_NOT_EXIST, new ModelIdDefectParams().withId(id));
    }

    public static Defect<Void> invalidAppLinkFormat() {
        return new Defect<>(AdGroupDefectIds.Gen.INVALID_APP_LINK_FORMAT);
    }

    public static Defect appStoreIsNotSupported(List<String> supportedAppStores) {
        return new Defect<>(AdGroupDefectIds.AppStoreDomain.APP_STORE_IS_NOT_SUPPORTED,
                new AppStoreDomainDefectParams(supportedAppStores));
    }

    public static Defect invalidAppStoreUrl() {
        return new Defect<>(AdGroupDefectIds.Gen.INVALID_APP_STORE_URL);
    }

    public static Defect invalidDynamicTextDomain() {
        return new Defect<>(AdGroupDefectIds.Gen.INVALID_DYNAMIC_TEXT_DOMAIN);
    }

    public static Defect dynamicTextDomainIsNotSet() {
        return new Defect<>(AdGroupDefectIds.Gen.DYNAMIC_TEXT_DOMAIN_IS_NOT_SET);
    }

    public static Defect minOsVersionIsNotSet() {
        return new Defect<>(AdGroupDefectIds.Gen.MIN_OS_VERSION_IS_NOT_SET);
    }

    public static Defect invalidMinOsVersion() {
        return new Defect<>(AdGroupDefectIds.Gen.INVALID_MIN_OS_VERSION);
    }

    public static Defect deviceTargetingIsNotSet() {
        return new Defect<>(AdGroupDefectIds.Gen.DEVICE_TARGETING_IS_NOT_SET);
    }

    public static Defect networkTargetingIsNotSet() {
        return new Defect<>(AdGroupDefectIds.Gen.NETWORK_TARGETING_IS_NOT_SET);
    }

    public static Defect notFound() {
        return new Defect<>(AdGroupDefectIds.Gen.NOT_FOUND);
    }

    public static Defect unableToDelete() {
        return new Defect<>(AdGroupDefectIds.Gen.UNABLE_TO_DELETE);
    }

    public static Defect duplicatedObject() {
        return new Defect<>(AdGroupDefectIds.Gen.MUST_NOT_CONTAIN_DUPLICATED_OBJECTS);
    }

    public static Defect<Void> adGroupTypeNotSupported() {
        return new Defect<>(AdGroupDefectIds.Gen.AD_GROUP_TYPE_NOT_SUPPORTED);
    }

    public static Defect<Void> inconsistentAdGroupType() {
        return new Defect<>(AdGroupDefectIds.Gen.INCONSISTENT_AD_GROUP_TYPE);
    }

    public static Defect<Void> inconsistentDynamicAdGroupType() {
        return new Defect<>(AdGroupDefectIds.Gen.INCONSISTENT_DYNAMIC_AD_GROUP_TYPE);
    }

    public static Defect<Void> eitherKeywordsOrRetargetingsAllowed() {
        return new Defect<>(AdGroupDefectIds.Gen.EITHER_KEYWORDS_OR_RETARGETINGS_ALLOWED);
    }

    public static Defect<Void> emptyContentCategoriesNotAllowed() {
        return new Defect<>(AdGroupDefectIds.Gen.EMPTY_CONTENT_CATEGORIES_NOT_ALLOWED);
    }

    public static Defect<Void> keywordsNotAllowed() {
        return new Defect<>(AdGroupDefectIds.Gen.KEYWORDS_NOT_ALLOWED);
    }

    public static Defect<Void> bidModifiersNotAllowed() {
        return new Defect<>(AdGroupDefectIds.Gen.BID_MODIFIERS_NOT_ALLOWED);
    }

    public static Defect<Void> minusKeywordsNotAllowed() {
        return new Defect<>(AdGroupDefectIds.Gen.MINUS_KEYWORDS_NOT_ALLOWED);
    }

    public static Defect<Void> restrictedRegions() {
        return new Defect<>(AdGroupDefectIds.Gen.RESTRICTED_REGIONS);
    }

    public static Defect<Void> storeUrlMustBeTheSameAsUrlInMobileContentCampaign() {
        return new Defect<>(AdGroupDefectIds.Gen.STORE_URL_MUST_BE_SAME_AS_URL_IN_MOBILE_CONTENT_CAMPAIGN);
    }

    public static Defect<Void> storeUrlMustBeTheSameForAllGroupsInMobileContentCampaign() {
        return new Defect<>(AdGroupDefectIds.Gen.STORE_URL_MUST_BE_SAME_FOR_ALL_GROUPS_IN_MOBILE_CONTENT_CAMPAIGN);
    }

    public static Defect<Void> notAllowedValue() {
        return new Defect<>(AdGroupDefectIds.Gen.NOT_ALLOWED_VALUE);
    }

    public static Defect<Void> finishTimeShouldBeGreaterThanStartTime() {
        return new Defect<>(AdGroupDefectIds.Gen.FINISH_TIME_SHOULD_BE_GREATER_THAN_START_TIME);
    }

    public static Defect<Void> contentPromotionSeveralTypesNotAllowed() {
        return new Defect<>(AdGroupDefectIds.Gen.CONTENT_PROMOTION_SEVERAL_TYPES_NOT_ALLOWED);
    }

    public static Defect<Void> contentPromotionDistinctTypesWithExisting() {
        return new Defect<>(AdGroupDefectIds.Gen.CONTENT_PROMOTION_DISTINCT_TYPE_FROM_EXISTING);
    }

    public static Defect<Void> contentPromotionAdGroupContentTypeChanged() {
        return new Defect<>(AdGroupDefectIds.Gen.CONTENT_PROMOTION_ADGROUP_TYPE_CHANGED);
    }

    public static Defect<Void> onlyOneDefaultAdGroupAllowed() {
        return new Defect<>(AdGroupDefectIds.Gen.ONLY_ONE_DEFAULT_AD_GROUP_ALLOWED);
    }

    public static Defect<Void> errorsWhileCopyingAdGroups() {
        return new Defect<>(AdGroupDefectIds.Gen.ERRORS_WHILE_COPYING_ADGROUPS);
    }

    public static Defect<Void> priceSalesDisallowedAdGroupTypes() {
        return new Defect<>(AdGroupDefectIds.Gen.PRICE_SALES_DISALLOWED_ADGROUP_TYPE);
    }

    public static Defect<Void> adGroupStatusArchived() {
        return new Defect<>(AdGroupDefectIds.Gen.AD_GROUP_STATUS_ARCHIVED);
    }

    public static Defect<Void> adGroupStatusStopped() {
        return new Defect<>(AdGroupDefectIds.Gen.AD_GROUP_STATUS_STOPPED);
    }

    public static Defect priceSalesTooManyTargetings(
            Integer currentAmount,
            Integer lowerLimit,
            Integer upperLimit,
            Set<PricePackageRetargetingSubCategory> categories) {
        return new Defect<>(AdGroupDefectIds.PriceSalesTargetingAmount.TOO_MANY_TARGETINGS,
                new PriceSalesTargetingAmountDefectParams()
                        .withCurrentAmount(currentAmount)
                        .withLowerLimit(lowerLimit)
                        .withUpperLimit(upperLimit)
                        .withCategories(categories));
    }
    public static Defect priceSalesTooFewTargetings(
            Integer currentAmount,
            Integer lowerLimit,
            Integer upperLimit,
            Set<PricePackageRetargetingSubCategory> categories) {
        return new Defect<>(AdGroupDefectIds.PriceSalesTargetingAmount.TOO_FEW_TARGETINGS,
                new PriceSalesTargetingAmountDefectParams()
                        .withCurrentAmount(currentAmount)
                        .withLowerLimit(lowerLimit)
                        .withUpperLimit(upperLimit)
                        .withCategories(categories));
    }

    public static Defect<Void> priceSalesDisallowedMetrikaSegments() {
        return new Defect<>(AdGroupDefectIds.Gen.PRICE_SALES_DISALLOWED_METRIKA_SEGMENTS);
    }

    public static Defect<Void> priceSalesDisallowedAudienceSegments() {
        return new Defect<>(AdGroupDefectIds.Gen.PRICE_SALES_DISALLOWED_AUDIENCE_SEGMENTS);
    }

    public static Defect<Void> cpmPriceAdGroupTypeNotAllowed() {
        return new Defect<>(AdGroupDefectIds.Gen.PRICE_SALES_AD_GROUP_TYPE_NOT_ALLOWED);
    }

    public static Defect<Void> cpmPriceInvalidPriority() {
        return new Defect<>(AdGroupDefectIds.Gen.PRICE_SALES_INVALID_PRIORITY);
    }

    public static Defect<CollectionValuesDefectParams<Long>> requiredAgeVariable(
            List<Long> bannerIds) {
        return new Defect<>(AdGroupDefectIds.Banners.REQUIRED_AGE_VARIABLE,
                CollectionValuesDefectParams.of(bannerIds));
    }

    public static Defect<Void> cpmPriceAdGroupUseNotAllowedBidModifiers() {
        return new Defect<>(AdGroupDefectIds.Gen.PRICE_SALES_AD_GROUP_USE_NOT_ALLOWED_BID_MODIFIERS);
    }

    public static Defect<Void> cpmPriceAdGroupNotAllowedMobilePlatformsCombination() {
        return new Defect<>(AdGroupDefectIds.Gen.PRICE_SALES_AD_GROUP_NOT_ALLOWED_MOBILE_PLATFORMS_COMBINATION);
    }

    public static Defect<Void> bsTagNotAllowed() {
        return new Defect<>(AdGroupDefectIds.Gen.BS_TAG_NOT_ALLOWED);
    }

}
