package ru.yandex.direct.core.entity.adgroup.service.validation.types;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.adgroup.model.PageBlock;
import ru.yandex.direct.core.entity.placements.model1.PlacementType;
import ru.yandex.direct.core.entity.placements.repository.PlacementRepository;
import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;

@Component
@ParametersAreNonnullByDefault
public class AdGroupPageBlocksValidatorFactory {

    private final PlacementRepository placementRepository;

    @Autowired
    public AdGroupPageBlocksValidatorFactory(PlacementRepository placementRepository) {
        this.placementRepository = placementRepository;
    }

    public <T extends AdGroup, TPropHolder extends Model> AdGroupPageBlocksValidator<T, TPropHolder> createValidator(
            List<T> adGroups, ModelProperty<TPropHolder, List<PageBlock>> pageBlocksProperty,
            PlacementType allowedPlacementType, int maxCount, boolean testingPagesFeatureEnabled) {
        return new AdGroupPageBlocksValidator<>(placementRepository, adGroups, pageBlocksProperty, allowedPlacementType,
                maxCount, testingPagesFeatureEnabled);
    }
}
