package ru.yandex.direct.core.entity.adgroup.service.validation.types;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupPriceSales;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.adgroup.service.AdGroupCpmPriceUtils.PRIORITY_DEFAULT;
import static ru.yandex.direct.core.entity.adgroup.service.AdGroupCpmPriceUtils.PRIORITY_SPECIFIC;
import static ru.yandex.direct.validation.constraint.CommonConstraints.inSet;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;

@ParametersAreNonnullByDefault
public class AdGroupPriceSalesValidator<T extends AdGroupPriceSales> implements Validator<T, Defect> {

    @Override
    public ValidationResult<T, Defect> apply(T adGroup) {
        var vb = ModelItemValidationBuilder.of(adGroup);

        vb.item(T.PRIORITY)
                .check(notNull())
                .check(inSet(Set.of(PRIORITY_DEFAULT, PRIORITY_SPECIFIC)));

        return vb.getResult();
    }
}
