package ru.yandex.direct.core.entity.adgroup.service.validation.types;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

/**
 * Интерфейс, которому соответствуют классы с логикой валидации групп объявлений,
 * которая зависит от типа группы. Один класс-валидатор отвечает за один тип группы.
 * Класс-валидатор должен быть непараметризированным, реализовывать
 * специализацию этого интерфейса.
 *
 * @param <T> конкретный класс модели (отнаследованный от абстрактного AdGroup),
 *            за который отвечает этот класс-валидатор
 */

@ParametersAreNonnullByDefault
interface AdGroupTypeSpecificValidationService<T extends AdGroup> {

    /**
     * Провалидировать специфичные для данного типа изменения групп
     */
    ValidationResult<List<ModelChanges<T>>, Defect> validateModelChanges(ClientId clientId,
                                                                         List<ModelChanges<T>> modelChangesList);

    /**
     * Провалидировать специфичные для данного типа группы поля в списке групп
     */
    ValidationResult<List<T>, Defect> validateAdGroups(ClientId clientId, List<T> adGroups);

    /**
     * Провалидировать специфичные для данного типа добавления групп
     */
    default ValidationResult<List<T>, Defect> validateAddAdGroups(ClientId clientId, List<T> adGroups) {
        return ValidationResult.success(adGroups);
    }

    Class<T> getAdGroupClass();
}
