package ru.yandex.direct.core.entity.adgroup.service.validation.types

import ru.yandex.direct.core.entity.adgroup.model.AdGroupWithFeedIdAndFilter
import ru.yandex.direct.core.entity.feed.service.FeedService
import ru.yandex.direct.core.entity.feedfilter.validation.FeedFilterValidator
import ru.yandex.direct.core.entity.performancefilter.service.PerformanceFilterStorage
import ru.yandex.direct.dbutil.model.ClientId
import ru.yandex.direct.validation.builder.When
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder

class AdGroupWithFeedIdAndFilterValidator<T : AdGroupWithFeedIdAndFilter>(
    private val filterSchemaStorage: PerformanceFilterStorage,
    feedService: FeedService, clientId: ClientId, adGroups: List<AdGroupWithFeedIdAndFilter>
) : AdGroupWithFeedIdValidator<T>(Builder(feedService, clientId, adGroups)) {

    override fun validate(index: Int, adGroup: T): ValidationResult<T, Defect<Any>> =
        super.validate(index, adGroup).merge(validateFilter(adGroup))

    private fun validateFilter(adGroup: T): ValidationResult<T, Defect<Any>> =
        ModelItemValidationBuilder.of(adGroup).apply {
            item(AdGroupWithFeedIdAndFilter.FEED_FILTER).apply {
                lazyFeedById.get()[adGroup.feedId]?.let { feed ->
                    checkBy(FeedFilterValidator(filterSchemaStorage.getFilterSchema(
                        feed.businessType, feed.feedType, feed.source
                    )), When.notNull())
                }
            }
        }.result

}
