package ru.yandex.direct.core.entity.adgroup.service.validation.types;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;


@ParametersAreNonnullByDefault
public abstract class BaseAdGroupTypeSpecificValidationService<T extends AdGroup> implements AdGroupTypeSpecificValidationService<T> {

    @Override
    public ValidationResult<List<ModelChanges<T>>, Defect> validateModelChanges(ClientId clientId,
                                                                                List<ModelChanges<T>> modelChanges) {
        return ValidationResult.success(modelChanges);
    }

    @Override
    public ValidationResult<List<T>, Defect> validateAdGroups(ClientId clientId, List<T> adGroups) {
        ListValidationBuilder<T, Defect> vb = ListValidationBuilder.of(adGroups);
        vb.checkEachBy(this::validateAdGroup);
        return vb.getResult();
    }

    /**
     * Провалидировать специфичные для данного типа группы поля
     */
    abstract ValidationResult<T, Defect> validateAdGroup(T adGroup);
}
