package ru.yandex.direct.core.entity.adgroup.service.validation.types;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.adgroup.model.DynSmartAdGroup;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.feed.validation.FeedDefects.feedBodyFieldIsTooLong;
import static ru.yandex.direct.core.entity.feed.validation.FeedDefects.feedNameFieldIsTooLong;
import static ru.yandex.direct.validation.constraint.StringConstraints.maxStringLength;
import static ru.yandex.direct.validation.constraint.StringConstraints.onlyUtf8Mb3Symbols;
import static ru.yandex.direct.validation.constraint.StringConstraints.validTrackingParams;

@ParametersAreNonnullByDefault
public abstract class BaseDynSmartAdGroupValidationService<T extends DynSmartAdGroup> extends BaseAdGroupTypeSpecificValidationService<T> {
    public static final int MAX_BODY_LENGTH = 512;
    public static final int MAX_NAME_LENGTH = 512;
    public static final int MAX_TRACKING_PARAMS_SIZE = 1024;

    @Override
    ValidationResult<T, Defect> validateAdGroup(T adGroup) {
        ModelItemValidationBuilder<T> vb = ModelItemValidationBuilder.of(adGroup);
        vb.item(DynSmartAdGroup.FIELD_TO_USE_AS_NAME)
                .check(onlyUtf8Mb3Symbols())
                .check(maxStringLength(MAX_NAME_LENGTH), feedNameFieldIsTooLong(MAX_NAME_LENGTH));
        vb.item(DynSmartAdGroup.FIELD_TO_USE_AS_BODY)
                .check(onlyUtf8Mb3Symbols())
                .check(maxStringLength(MAX_BODY_LENGTH), feedBodyFieldIsTooLong(MAX_BODY_LENGTH));
        vb.item(DynSmartAdGroup.TRACKING_PARAMS)
                .check(validTrackingParams())
                .check(onlyUtf8Mb3Symbols())
                .check(maxStringLength(MAX_TRACKING_PARAMS_SIZE));
        //TODO реализовать валидацию допустимости полей фида: DIRECT-90366
        return vb.getResult();
    }
}
