package ru.yandex.direct.core.entity.adgroup.service.validation.types;


import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.model.ContentPromotionVideoAdGroup;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

/**
 * Класс с логикой валидации групп объявлений типа CONTENT_PROMOTION_VIDEO при операциях добавления и обновления групп
 */
@Component
@ParametersAreNonnullByDefault
public class ContentPromotionVideoAdGroupValidation extends
        BaseAdGroupTypeSpecificValidationService<ContentPromotionVideoAdGroup> {

    //Вся валидация вынесена в ContentPromotionContentTypesValidator
    @Override
    public ValidationResult<ContentPromotionVideoAdGroup, Defect> validateAdGroup(
            ContentPromotionVideoAdGroup adGroup) {
        return ModelItemValidationBuilder.of(adGroup).getResult();
    }

    @Override
    public Class<ContentPromotionVideoAdGroup> getAdGroupClass() {
        return ContentPromotionVideoAdGroup.class;
    }
}
