package ru.yandex.direct.core.entity.adgroup.service.validation.types;

import javax.annotation.ParametersAreNonnullByDefault;

import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.adgroup.model.CpmGeoproductAdGroup;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefects.minusKeywordsNotAllowed;
import static ru.yandex.direct.validation.builder.Constraint.fromPredicate;

@Component
@ParametersAreNonnullByDefault
public class CpmGeoproductAdGroupValidation extends BaseAdGroupTypeSpecificValidationService<CpmGeoproductAdGroup> {
    @Override
    public ValidationResult<CpmGeoproductAdGroup, Defect> validateAdGroup(CpmGeoproductAdGroup adGroup) {
        ModelItemValidationBuilder<CpmGeoproductAdGroup> vb = ModelItemValidationBuilder.of(adGroup);

        vb.item(AdGroup.MINUS_KEYWORDS)
                .check(fromPredicate(CollectionUtils::isEmpty, minusKeywordsNotAllowed()));
        vb.item(AdGroup.LIBRARY_MINUS_KEYWORDS_IDS)
                .check(fromPredicate(CollectionUtils::isEmpty, minusKeywordsNotAllowed()));

        return vb.getResult();
    }

    @Override
    public Class<CpmGeoproductAdGroup> getAdGroupClass() {
        return CpmGeoproductAdGroup.class;
    }
}
