package ru.yandex.direct.core.entity.adgroup.service.validation.types;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.model.DynamicTextAdGroup;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefects.dynamicTextDomainIsNotSet;
import static ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefects.invalidDynamicTextDomain;
import static ru.yandex.direct.core.validation.constraints.Constraints.validDomain;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;
import static ru.yandex.direct.validation.constraint.StringConstraints.maxStringLength;
import static ru.yandex.direct.validation.constraint.StringConstraints.notBlank;
import static ru.yandex.direct.validation.constraint.StringConstraints.notEmpty2;

@Component
@ParametersAreNonnullByDefault
public class DynamicTextAdGroupValidation extends BaseDynSmartAdGroupValidationService<DynamicTextAdGroup> {
    static final int MAX_TRACKING_PARAMS_SIZE = 1024;
    static final int MAX_DOMAIN_URL_SIZE = 100;

    @Override
    public ValidationResult<DynamicTextAdGroup, Defect> validateAdGroup(DynamicTextAdGroup adGroup) {
        var dynSmartResult = super.validateAdGroup(adGroup);

        ModelItemValidationBuilder<DynamicTextAdGroup> vb = ModelItemValidationBuilder.of(adGroup);
        vb.item(DynamicTextAdGroup.DOMAIN_URL)
                .check(notNull(), dynamicTextDomainIsNotSet())
                .check(notEmpty2(), dynamicTextDomainIsNotSet())
                .check(notBlank(), invalidDynamicTextDomain(), When.isValid())
                .check(maxStringLength(MAX_DOMAIN_URL_SIZE), When.isValid())
                .check(validDomain(), invalidDynamicTextDomain(), When.isValid());

        return dynSmartResult.merge(vb.getResult());
    }

    @Override
    public Class<DynamicTextAdGroup> getAdGroupClass() {
        return DynamicTextAdGroup.class;
    }

}
