package ru.yandex.direct.core.entity.adgroup.service.validation.types;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.model.McBannerAdGroup;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

@Component
@ParametersAreNonnullByDefault
public class McBannerAdGroupValidation extends BaseAdGroupTypeSpecificValidationService<McBannerAdGroup> {
    @Override
    public ValidationResult<McBannerAdGroup, Defect> validateAdGroup(McBannerAdGroup adGroup) {
        // все провалидировано в рамках AdGroupValidationService.validate
        ModelItemValidationBuilder<McBannerAdGroup> vb = ModelItemValidationBuilder.of(adGroup);
        return vb.getResult();
    }

    @Override
    public Class<McBannerAdGroup> getAdGroupClass() {
        return McBannerAdGroup.class;
    }
}
