package ru.yandex.direct.core.entity.adgroup.service.validation.types;

import java.util.List;
import java.util.Optional;

import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.pricepackage.model.PricePackage;
import ru.yandex.direct.core.entity.pricepackage.model.TargetingsCustom;
import ru.yandex.direct.regions.GeoTree;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.result.Defect;

import static java.util.Collections.emptyList;
import static ru.yandex.direct.core.entity.pricepackage.service.validation.PricePackageValidator.REGION_TYPE_REGION;
import static ru.yandex.direct.utils.CommonUtils.nvl;
import static ru.yandex.direct.validation.builder.Constraint.fromPredicate;
import static ru.yandex.direct.validation.defect.CommonDefects.invalidValue;

public class PriceSalesAdGroupGeoValidatorBase {
    protected final GeoTree priceSalesGeoTree;
    protected final PricePackage pricePackage;

    public PriceSalesAdGroupGeoValidatorBase(GeoTree priceSalesGeoTree, PricePackage pricePackage) {
        this.priceSalesGeoTree = priceSalesGeoTree;
        this.pricePackage = pricePackage;
    }

    /**
     * По настройкам пакета нужно проверять точный список регионов, не поддерево.
     */
    protected static boolean exactRegionCheck(PricePackage pricePackage) {
        Integer geoType = Optional.ofNullable(pricePackage)
                .map(PricePackage::getTargetingsCustom)
                .map(TargetingsCustom::getGeoType)
                .orElse(-1);
        return geoType.equals(REGION_TYPE_REGION);
    }

    protected Constraint<List<Long>, Defect> fixedGeoUsed() {
        List<Long> geoFixed = nvl(pricePackage.getTargetingsFixed().getGeo(), emptyList());
        return fromPredicate(adgroupGeo -> StreamEx.of(geoFixed)
                        .allMatch(fixed -> {
                            var fixedRegIdsWithPar = priceSalesGeoTree.regionIdWithParents(fixed);
                            return !adgroupGeo.contains(-fixed)//Фиксированные не должны быть как минус регион
                                    //Они могут приходить как положительное число,
                                    // либо не приходить, если есть родительский
                                    && StreamEx.of(fixedRegIdsWithPar).anyMatch(it -> adgroupGeo.contains(it));
                        }),
                invalidValue());
    }
}
