package ru.yandex.direct.core.entity.adgroup.service.validation.types;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.model.CpmPriceCampaign;
import ru.yandex.direct.core.entity.pricepackage.model.PricePackage;
import ru.yandex.direct.regions.GeoTree;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.DefaultValidator;

import static java.util.Collections.emptyList;
import static ru.yandex.direct.utils.CommonUtils.nvl;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;
import static ru.yandex.direct.validation.builder.Constraint.fromPredicate;
import static ru.yandex.direct.validation.constraint.CommonConstraints.isEqualCollection;
import static ru.yandex.direct.validation.defect.CommonDefects.invalidValue;

@ParametersAreNonnullByDefault
class PriceSalesDefaultAdGroupGeoValidator
        extends PriceSalesAdGroupGeoValidatorBase
        implements DefaultValidator<List<Long>> {

    private final List<Long> snapshotGeoExpanded;

    PriceSalesDefaultAdGroupGeoValidator(GeoTree priceSalesGeoTree, CpmPriceCampaign campaign,
                                         PricePackage pricePackage) {
        super(priceSalesGeoTree, pricePackage);
        this.snapshotGeoExpanded = campaign.getFlightTargetingsSnapshot().getGeoExpanded();
    }

    @Override
    public ValidationResult<List<Long>, Defect> apply(List<Long> adGroupGeo) {
        return ItemValidationBuilder.<List<Long>, Defect>of(adGroupGeo)
                .check(isEqualCollection(snapshotGeoExpanded, invalidValue()),
                        When.isValidAnd(When.isFalse(exactRegionCheck(pricePackage))))
                .check(fromPredicate(adgroupGeo ->//Лишнее гео пытаемся добавить
                                nvl(pricePackage.getTargetingsCustom().getGeo(), emptyList())
                                        .containsAll(mapList(adgroupGeo, Math::abs)),
                        invalidValue()), When.isValidAnd(When.isTrue(exactRegionCheck(pricePackage))))
                .check(fixedGeoUsed(),
                        When.isValidAnd(When.isTrue(exactRegionCheck(pricePackage))))
                .getResult();
    }

}
