package ru.yandex.direct.core.entity.adgroup.service.validation.types;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.campaign.model.CpmPriceCampaign;
import ru.yandex.direct.core.entity.pricepackage.model.PricePackage;
import ru.yandex.direct.core.util.GeoTreeUtils;
import ru.yandex.direct.regions.GeoTree;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.DefaultValidator;

import static java.util.Collections.emptyList;
import static ru.yandex.direct.core.entity.region.validation.RegionIdDefects.geoEmptyRegions;
import static ru.yandex.direct.core.entity.region.validation.RegionIdsValidator.allRegionsExist;
import static ru.yandex.direct.utils.CommonUtils.nvl;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;
import static ru.yandex.direct.validation.builder.Constraint.fromPredicate;
import static ru.yandex.direct.validation.builder.When.isFalse;
import static ru.yandex.direct.validation.builder.When.isTrue;
import static ru.yandex.direct.validation.builder.When.isValid;
import static ru.yandex.direct.validation.constraint.CommonConstraints.eachNotNull;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;
import static ru.yandex.direct.validation.defect.CommonDefects.invalidValue;

@ParametersAreNonnullByDefault
public class PriceSalesSpecificAdGroupGeoValidator
        extends PriceSalesAdGroupGeoValidatorBase
        implements DefaultValidator<List<Long>> {

    private final Set<Long> geoExpanded;
    private final AdGroup defAdGroup;

    PriceSalesSpecificAdGroupGeoValidator(GeoTree priceSalesGeoTree, CpmPriceCampaign campaign,
                                          PricePackage pricePackage, AdGroup defAdGroup) {
        super(priceSalesGeoTree, pricePackage);
        this.defAdGroup = defAdGroup;
        this.geoExpanded = new HashSet<>(Optional.ofNullable(geoExpanded(campaign)).orElse(emptyList()));
    }

    private List<Long> geoExpanded(CpmPriceCampaign campaign) {
        if (!exactRegionCheck(pricePackage)) {
            return campaign.getFlightTargetingsSnapshot().getGeoExpanded();
        }
        //брать с дефольной группы, а не с кампании
        if (defAdGroup != null) {
            return defAdGroup.getGeo();
        }
        return null;
    }

    @Override
    public ValidationResult<List<Long>, Defect> apply(List<Long> adGroupGeo) {
        return ItemValidationBuilder.<List<Long>, Defect>of(adGroupGeo)
                .check(notNull())
                .check(eachNotNull(), geoEmptyRegions(), isValid())
                .check(allRegionsExist(priceSalesGeoTree), isValid())
                .check(fromPredicate(adgroupGeo ->
                                GeoTreeUtils.isGeoSubTree(priceSalesGeoTree, adgroupGeo, geoExpanded),
                        invalidValue()), When.isValidAnd(isFalse(geoExpanded.isEmpty())))
                .check(fromPredicate(adgroupGeo ->//Лишнее гео пытаемся добавить
                                nvl(pricePackage.getTargetingsCustom().getGeo(), emptyList())
                                        .containsAll(mapList(adgroupGeo, Math::abs)),
                        invalidValue()),
                        When.isValidAnd(isTrue(exactRegionCheck(pricePackage) && !pricePackage.needDefaultAdGroup())))
                .check(fixedGeoUsed(),
                        When.isValidAnd(isTrue(exactRegionCheck(pricePackage) && !pricePackage.needDefaultAdGroup())))
                .getResult();
    }
}
