package ru.yandex.direct.core.entity.adgroup.service.validation.types

import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.adgroup.model.TextAdGroup
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.UsersSegmentsValidationUtil.validateAdGroupWithUsersSegments
import ru.yandex.direct.core.entity.feed.service.FeedService
import ru.yandex.direct.core.entity.performancefilter.service.PerformanceFilterStorage
import ru.yandex.direct.dbutil.model.ClientId
import ru.yandex.direct.validation.builder.ListValidationBuilder
import ru.yandex.direct.validation.builder.When
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder

@Component
class TextAdGroupValidation(
    @Autowired val feedService: FeedService,
    @Autowired val filterSchemaStorage: PerformanceFilterStorage
) : BaseDynSmartAdGroupValidationService<TextAdGroup>() {

    override fun getAdGroupClass() = TextAdGroup::class.java

    override fun validateAdGroups(
        clientId: ClientId,
        adGroups: List<TextAdGroup>
    ): ValidationResult<List<TextAdGroup>, Defect<Any>> {
        val feedAndFilterValidator =
            AdGroupWithFeedIdAndFilterValidator<TextAdGroup>(filterSchemaStorage, feedService, clientId, adGroups)
        val vb = ListValidationBuilder.of<TextAdGroup, Defect<Any>>(adGroups).apply {
            checkEachBy(feedAndFilterValidator, When.valueIs { it.feedId != null })
            checkEachBy { adGroup -> validateAdGroupWithUsersSegments(adGroup) }
        }
        return super.validateAdGroups(clientId, adGroups).merge(vb.result)
    }

    private fun validateAdGroupWithUsersSegments(adGroup: TextAdGroup): ValidationResult<TextAdGroup, Defect<Any>> {
        val vb = ModelItemValidationBuilder.of<TextAdGroup>(adGroup)
        validateAdGroupWithUsersSegments(vb, adGroup.type, false)
        return vb.result
    }
}
