package ru.yandex.direct.core.entity.adgroupadditionaltargeting;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.InterfaceLang;

import static ru.yandex.direct.utils.FunctionalUtils.mapSet;

/**
 * Константы из БК-шной библиотеки
 * https://a.yandex-team.ru/arc/trunk/arcadia/yabs/server/libs/db/lang_code.cpp
 */
@ParametersAreNonnullByDefault
public class InterfaceLangConstants {

    public static final Set<String> INTERFACE_LANG = mapSet(Set.of(InterfaceLang.values()),
            interfaceLang -> interfaceLang.getTypedValue().toUpperCase());

    private InterfaceLangConstants() {
    }
}
