package ru.yandex.direct.core.entity.adgroupadditionaltargeting;

import java.util.Map;
import java.util.Set;

import com.google.common.collect.ImmutableMap;

/**
 * Константы из БК-шной библиотеки ua_traits
 * https://a.yandex-team.ru/arc/trunk/arcadia/yabs/libs/ua_traits/orig/pymodules
 * Были удалены дубли для DEVICE_VENDOR, подробнее: https://st.yandex-team.ru/DIRECT-112281
 */
public class UaTraitsConstants {
    public static final Map<Long, String> BROWSER_BASE = ImmutableMap.<Long, String>builder()
            .put(1L, "Chromium")
            .put(2L, "Safari")
            .build();

    public static final Set<Long> BROWSER_BASE_VALID_VALUES = BROWSER_BASE.keySet();

    public static final Map<Long, String> BROWSER_ENGINE = ImmutableMap.<Long, String>builder()
            .put(1L, "Unknown")
            .put(2L, "Proprietary")
            .put(3L, "Presto")
            .put(4L, "Trident")
            .put(5L, "TextBased")
            .put(6L, "Edge")
            .put(7L, "KHTML")
            .put(8L, "WebKit")
            .put(9L, "Gecko")
            .put(10L, "UCBrowser")
            .build();

    public static final Set<Long> BROWSER_ENGINE_VALID_VALUES = BROWSER_ENGINE.keySet();

    public static final Map<Long, String> BROWSER_NAME = ImmutableMap.<Long, String>builder()
            .put(1L, "Unknown")
            .put(2L, "Chrome")
            .put(3L, "MSIE")
            .put(4L, "Opera")
            .put(5L, "Safari")
            .put(6L, "Firefox")
            .put(7L, "YandexBrowser")
            .put(8L, "Novarra-Vision")
            .put(9L, "Dolfin")
            .put(10L, "Playstation")
            .put(11L, "Vivaldi")
            .put(12L, "Lunascape")
            .put(13L, "Links")
            .put(14L, "Netscape")
            .put(15L, "LGBrowser")
            .put(16L, "Mail.ru")
            .put(17L, "SkyFire")
            .put(18L, "Dolphin")
            .put(19L, "Dillo")
            .put(20L, "K-Meleon")
            .put(21L, "WebOSBrowser")
            .put(22L, "CM Browser")
            .put(23L, "AdobeAIR")
            .put(24L, "Minimo")
            .put(25L, "PaleMoon")
            .put(26L, "ELinks")
            .put(27L, "OmniWeb")
            .put(28L, "UCBrowser")
            .put(29L, "AndroidBrowser")
            .put(30L, "iTunes")
            .put(31L, "YandexSearch")
            .put(32L, "Rekonq")
            .put(33L, "Dalvik")
            .put(34L, "Puffin")
            .put(35L, "NetSurf")
            .put(36L, "BlackBerry")
            .put(37L, "SeaMonkey")
            .put(38L, "Midori")
            .put(39L, "Tizen")
            .put(40L, "MAUI WAP Browser")
            .put(41L, "Baidu")
            .put(42L, "OperaMini")
            .put(43L, "NetFront")
            .put(44L, "Mozilla")
            .put(45L, "Coast")
            .put(46L, "Galeon")
            .put(47L, "Conkeror")
            .put(48L, "Konqueror")
            .put(49L, "Blazer")
            .put(50L, "UbuntuBrowser")
            .put(51L, "Jasmine")
            .put(52L, "QtWeb")
            .put(53L, "Arora")
            .put(54L, "Epiphany")
            .put(55L, "Edge")
            .put(56L, "Amigo")
            .put(57L, "GoogleSearch")
            .put(58L, "NetFrontLifeBrowser")
            .put(59L, "Uzbl")
            .put(60L, "NokiaBrowser")
            .put(61L, "Flock")
            .put(62L, "Chromium")
            .put(63L, "QupZilla")
            .put(64L, "Ninesky")
            .put(65L, "OpenWave")
            .put(66L, "AvantBrowser")
            .put(67L, "GoogleWirelessTranscoder")
            .put(68L, "Nichrome")
            .put(69L, "Sleipnir")
            .put(70L, "MQQBrowser")
            .put(71L, "SEMC")
            .put(72L, "Camino")
            .put(73L, "SongBird")
            .put(74L, "Polaris")
            .put(75L, "Obigo")
            .put(76L, "NCSA Mosaic")
            .put(77L, "Iron")
            .put(78L, "Lynx")
            .put(79L, "OviBrowser")
            .put(80L, "Maxthon")
            .put(81L, "YandexInternet")
            .put(82L, "Docomo")
            .put(83L, "MobileFirefox")
            .put(84L, "Mercury")
            .put(85L, "OperaMobile")
            .put(86L, "ChromeMobile")
            .put(87L, "IEMobile")
            .put(88L, "MobileSafari")
            .put(89L, "WeChat")
            .put(90L, "Sputnik")
            .put(91L, "facebookexternalhit")
            .put(92L, "vkShare")
            .put(93L, "OdklBot")
            .put(94L, "GPlusSnippet")
            .put(95L, "Twitterbot")
            .put(96L, "MailRuConnect")
            .put(97L, "Samsung Internet")
            .put(98L, "CocCoc")
            .put(99L, "PhantomJS")
            .put(100L, "TansoDownloader")
            .put(101L, "MIUI")
            .put(102L, "YandexBrowserLite")
            .put(103L, "Yaani")
            .put(104L, "Elements Browser")
            .put(105L, "Otter")
            .put(106L, "EUI")
            .put(107L, "MZBrowser")
            .put(108L, "Waterfox")
            .put(109L, "Atom")
            .put(110L, "TolokaApp")
            .put(111L, "HeadlessChrome")
            .put(112L, "YandexLauncher")
            .put(113L, "Huawei Browser")
            .put(114L, "Opera Touch")
            .put(115L, "CriOS")
            .build();

    public static final Set<Long> BROWSER_NAME_VALID_VALUES = BROWSER_NAME.keySet();

    public static final Map<Long, String> DEVICE_VENDOR = ImmutableMap.<Long, String>builder()
            .put(1L, "ARCHOS")
            .put(2L, "Lenovo")
            .put(3L, "HTC")
            .put(4L, "Apple")
            .put(5L, "Sony Ericsson")
            .put(6L, "SAMSUNG")
            .put(7L, "HP")
            .put(8L, "Nokia")
            .put(9L, "HYUNDAI")
            .put(10L, "Acer")
            .put(11L, "WEXLER")
            .put(12L, "Huawei")
            .put(13L, "Amazon")
            .put(14L, "RIM")
            .put(15L, "ATIV")
            .put(16L, "Sony")
            .put(17L, "ASUS")
            .put(18L, "LG Electronics")
            .put(19L, "Google")
            .put(20L, "3Q")
            .put(21L, "Bliss")
            .put(22L, "Supersonic")
            .put(23L, "Imatch")
            .put(24L, "Ark")
            .put(25L, "Avivo")
            .put(26L, "Boway")
            .put(27L, "Beeline")
            .put(28L, "CCIT")
            .put(29L, "CKK")
            .put(30L, "Chuwi")
            .put(31L, "Cross")
            .put(32L, "CUBE")
            .put(33L, "Celkon")
            .put(34L, "Changhong")
            .put(35L, "Changjiang")
            .put(36L, "Cyrus")
            .put(37L, "Cloudfone")
            .put(38L, "Colors")
            .put(39L, "DEXP")
            .put(40L, "DiMO")
            .put(41L, "Doov")
            .put(42L, "DNS")
            .put(43L, "Torque")
            .put(44L, "Lenco")
            .put(45L, "NEO")
            .put(46L, "G-TiDE")
            .put(47L, "Zopo")
            .put(48L, "ADVAN")
            .put(49L, "BQ")
            .put(50L, "Lark")
            .put(51L, "Mediatek")
            .put(52L, "Vodafone")
            .put(53L, "Axioo")
            .put(54L, "E-Boda")
            .put(55L, "Yusun")
            .put(56L, "Lanix")
            .put(57L, "Mlled")
            .put(58L, "Onida")
            .put(59L, "Lexibook")
            .put(60L, "Spice")
            .put(61L, "Allview")
            .put(62L, "Micromax")
            .put(63L, "Tooky")
            .put(64L, "Viewsonic")
            .put(65L, "KNC")
            .put(66L, "Gigabyte")
            .put(67L, "Piranha")
            .put(68L, "Lovme")
            .put(69L, "Andromax")
            .put(70L, "Oppo")
            .put(71L, "Highscreen")
            .put(72L, "MegaFon")
            .put(73L, "Amaze")
            .put(74L, "Mobiistar")
            .put(75L, "Pegatron")
            .put(76L, "QUMO")
            .put(77L, "Harga HP")
            .put(78L, "iGO")
            .put(79L, "MyPhone")
            .put(80L, "Ghia")
            .put(81L, "Tesco")
            .put(82L, "Infinix")
            .put(83L, "SUPRA")
            .put(84L, "QSmart")
            .put(85L, "T-Smart")
            .put(86L, "Meizu")
            .put(87L, "Storex")
            .put(88L, "Discovery")
            .put(89L, "Elephone")
            .put(90L, "Plark")
            .put(91L, "MEEG")
            .put(92L, "Voto")
            .put(93L, "Vestel")
            .put(94L, "Uoogou")
            .put(95L, "GoClever")
            .put(96L, "Opsson")
            .put(97L, "Ritmix")
            .put(98L, "Optima")
            .put(99L, "Motorola")
            .put(100L, "KPT")
            .put(101L, "Casper")
            .put(102L, "Malata")
            .put(103L, "Azumi")
            .put(104L, "NVidia")
            .put(105L, "Ebest")
            .put(106L, "Irbis")
            .put(107L, "TurboPad")
            .put(108L, "Sharp")
            .put(109L, "Oysters")
            .put(110L, "Marshal")
            .put(111L, "UTime")
            .put(112L, "Explay")
            .put(113L, "Ematic")
            .put(114L, "Tecno")
            .put(115L, "PocketBook")
            .put(116L, "GFive")
            .put(117L, "RoverPad")
            .put(118L, "Rover")
            .put(119L, "Ainol")
            .put(120L, "Zte")
            .put(121L, "Lava")
            .put(122L, "Keneksi")
            .put(123L, "Hisense")
            .put(124L, "iOcean")
            .put(125L, "Pyle")
            .put(126L, "Prestigio")
            .put(127L, "UMI")
            .put(128L, "Haier")
            .put(129L, "Nomi")
            .put(130L, "Woxter")
            .put(131L, "Infocus")
            .put(132L, "Hosin")
            .put(133L, "Xiaomi")
            .put(134L, "Toshiba")
            .put(135L, "Vivax")
            .put(136L, "Coolpad")
            .put(137L, "Cubot")
            .put(138L, "OnePlus")
            .put(139L, "Fly")
            .put(140L, "Avea")
            .put(141L, "teXet")
            .put(142L, "Intex")
            .put(143L, "Denver")
            .put(144L, "Vivo")
            .put(145L, "K-Touch")
            .put(146L, "Maxtron")
            .put(147L, "Impression")
            .put(148L, "AMOI")
            .put(149L, "Digma")
            .put(150L, "Tesla")
            .put(151L, "Gionee")
            .put(152L, "Hoow")
            .put(153L, "Medion")
            .put(154L, "MediaMarkt")
            .put(155L, "Jinga")
            .put(156L, "Modecom")
            .put(157L, "Pantech")
            .put(158L, "iBall")
            .put(159L, "Panasonic")
            .put(160L, "XOLO")
            .put(161L, "Positivo")
            .put(162L, "General Mobile")
            .put(163L, "Karbonn")
            .put(164L, "Masstel")
            .put(165L, "MITO")
            .put(166L, "Symphony")
            .put(167L, "Proscan")
            .put(168L, "OBEE")
            .put(169L, "MaPan")
            .put(170L, "Kazam")
            .put(171L, "Dell")
            .put(172L, "JIAYU")
            .put(173L, "Newman")
            .put(174L, "Ramos")
            .put(175L, "Yota")
            .put(176L, "Etuline")
            .put(177L, "Philips")
            .put(178L, "QMobile")
            .put(179L, "i-Mobile")
            .put(180L, "Alcatel")
            .put(181L, "AKAI")
            .put(182L, "Dark")
            .put(183L, "Turkcell")
            .put(184L, "Vexia")
            .put(185L, "Doogee")
            .put(186L, "Evercoss")
            .put(187L, "General Satellite")
            .put(188L, "Thl")
            .put(189L, "JXD")
            .put(190L, "KliTON")
            .put(191L, "MTC")
            .put(193L, "Keener")
            .put(194L, "Microsoft")
            .put(195L, "Wiko")
            .put(196L, "KONKA")
            .put(197L, "Tele2")
            .put(198L, "4Good")
            .put(199L, "HOMTOM")
            .put(200L, "Senkatel")
            .put(201L, "SENSEIT")
            .put(202L, "Wileyfox")
            .put(203L, "MeeGoPad")
            .put(204L, "TurboPhone4G")
            .put(205L, "Siemens")
            .put(206L, "Basco")
            .put(207L, "Vertex")
            .put(208L, "Palm")
            .put(209L, "LeEco")
            .put(210L, "GoldStar")
            .put(212L, "Hasee")
            .put(213L, "MARSHALL")
            .put(214L, "Mlais")
            .put(215L, "Viking")
            .put(216L, "OUKITEL")
            .put(217L, "Telefunken")
            .put(218L, "Blackview")
            .put(219L, "FinePower")
            .put(220L, "Uhans")
            .put(221L, "Rombica")
            .put(222L, "Leagoo")
            .put(223L, "PPTV")
            .put(224L, "Smartfren")
            .put(225L, "Bluboo")
            .put(226L, "TP-Link")
            .put(227L, "RITZVIVA")
            .put(228L, "BlackBerry")
            .put(229L, "Ulefone")
            .put(230L, "Caterpillar")
            .put(231L, "Black Fox")
            .put(232L, "AGM")
            .put(233L, "Phicomm")
            .put(234L, "GeoTel")
            .put(235L, "Apls")
            .put(236L, "INOI")
            .put(237L, "Turbo")
            .put(238L, "Vernee")
            .put(239L, "GINZZU")
            .put(240L, "Firefly")
            .put(241L, "Yandex")
            .put(242L, "Maxvi")
            .put(243L, "Minix")
            .put(244L, "M-net")
            .put(245L, "Mann")
            .put(246L, "Artel")
            .put(247L, "Teclast")
            .put(248L, "Santin")
            .put(249L, "Pixus")
            .put(250L, "Zidoo")
            .put(251L, "Onda")
            .put(252L, "Starlight")
            .put(253L, "IUNI")
            .put(255L, "Noa")
            .build();

    public static final Set<Long> DEVICE_VENDOR_VALID_VALUES = DEVICE_VENDOR.keySet();

    public static final Map<Long, String> OS_FAMILY = ImmutableMap.<Long, String>builder()
            // в ua_trait есть, на нам не нужен
            // .put(1L, "")
            .put(2L, "Android")
            .put(3L, "iOS")
            .put(4L, "Windows Phone")
            .put(5L, "AIX")
            .put(6L, "Bada")
            .put(7L, "BlackBerry")
            .put(8L, "BREW")
            .put(9L, "ChromeOS")
            .put(10L, "FirefoxOS")
            .put(11L, "FreeBSD")
            .put(12L, "HP-UX")
            .put(13L, "IRIX")
            .put(14L, "Java")
            .put(15L, "Linux")
            .put(16L, "MacOS")
            .put(17L, "MeeGo")
            .put(18L, "Moblin")
            .put(19L, "NetBSD")
            .put(20L, "Nucleus")
            .put(21L, "OpenBSD")
            .put(22L, "OS/2")
            .put(23L, "PalmOS")
            .put(24L, "QNX")
            .put(25L, "RIMTabletOS")
            .put(26L, "Series40")
            .put(27L, "SunOS")
            .put(28L, "Symbian")
            .put(29L, "Tizen")
            .put(30L, "UbuntuTouch")
            .put(31L, "UNIX")
            .put(32L, "WebOS")
            .put(33L, "Windows")
            .put(34L, "WindowsMobile")
            .put(35L, "WindowsRT")
            .put(36L, "UnknownNix")
            .build();

    public static final Set<Long> OS_FAMILY_VALID_VALUES = OS_FAMILY.keySet();

    public static final Map<Long, String> OS_NAME = ImmutableMap.<Long, String>builder()
            .put(1L, "Android Jelly Bean")
            .put(2L, "Fedora")
            .put(3L, "Android Cupcake")
            .put(4L, "Android Lollipop")
            .put(5L, "Mac OS X Mavericks")
            .put(6L, "Android Bender")
            .put(7L, "Windows 8.1")
            .put(8L, "Windows 95")
            .put(9L, "Gentoo")
            .put(10L, "Windows XP")
            .put(11L, "Windows 98")
            .put(12L, "Mac OS X Tiger")
            .put(13L, "Android Froyo")
            .put(14L, "Windows ME")
            .put(15L, "Android Ice Cream Sandwich")
            .put(16L, "Android Eclair")
            .put(17L, "Ubuntu")
            .put(18L, "Windows 10")
            .put(19L, "Android Astro")
            .put(20L, "Mac OS X Mountain Lion")
            .put(21L, "Debian")
            .put(22L, "SUSE")
            .put(23L, "Windows Vista")
            .put(24L, "RedHat")
            .put(25L, "ALTLinux")
            .put(26L, "Windows 8")
            .put(27L, "Windows NT 3.51")
            .put(28L, "Mandriva")
            .put(29L, "Windows 7")
            .put(30L, "ASPLinux")
            .put(31L, "Windows NT 4.0")
            .put(32L, "Android KitKat")
            .put(33L, "CentOS")
            .put(34L, "Mac OS X Snow Leopard")
            .put(35L, "Mint")
            .put(36L, "Mac OS X Leopard")
            .put(37L, "Windows 2000")
            .put(38L, "Windows 3.11")
            .put(39L, "Windows Server 2003")
            .put(40L, "SplashTop")
            .put(41L, "Mac OS X Lion")
            .put(42L, "Android Donut")
            .put(43L, "Mac OS X Yosemite")
            .put(44L, "Android Honeycomb")
            .put(45L, "Android Gingerbread")
            .put(46L, "Mac OS X El Capitan")
            .put(47L, "Android Marshmallow")
            .put(48L, "Android Nougat")
            .put(49L, "Android Oreo")
            .put(50L, "Mac OS X Sierra")
            .put(51L, "Mac OS X High Sierra")
            .put(52L, "Mac OS X Mojave")
            .put(53L, "Android Pie")
            .build();

    public static final Set<Long> OS_NAME_VALID_VALUES = OS_NAME.keySet();

    private UaTraitsConstants() {
    }
}
