package ru.yandex.direct.core.entity.adgroupadditionaltargeting.configuration;

import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.AdGroupAdditionalTargeting;
import ru.yandex.direct.model.ModelProperty;

/**
 * Интерфейс-посредник, предоставляющий доступ к свойству VALUE из объектов типа {@link AdGroupAdditionalTargeting}
 *
 * @param <T> тип таргетинга ({@link AdGroupAdditionalTargeting})
 * @param <V> тип переменной value
 */
public interface AdGroupAdditionalTargetingValueAccessor<T extends AdGroupAdditionalTargeting, V>
        extends AdGroupAdditionalTargetingTypeAccessor<T> {

    Class<?> getValueClass();

    V getValue(T targeting);

    void setValue(T targeting, V value);

    ModelProperty<T, V> getValueModelProperty();
}
