package ru.yandex.direct.core.entity.adgroupadditionaltargeting.configuration;

import java.util.List;

import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.AdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.AdditionalTargetingValue;

/**
 * Интерфейс-посредник, предоставляющий доступ к параметризованному свойству VALUE таргетинга
 * Примеры параметризованных значений:
 * {@link AdditionalTargetingValue<Integer>}
 * {@link List<Long>}
 *
 * @param <T> тип таргетинга ({@link AdGroupAdditionalTargeting})
 * @param <V> тип переменной value
 */
public interface AdGroupAdditionalTargetingWithParametricValueAccessor
        <T extends AdGroupAdditionalTargeting, V>
        extends AdGroupAdditionalTargetingValueAccessor<T, V> {

    @Override
    Class<V> getValueClass();

    Class<?> getValueParameterClass();

}
